/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.CacheNode;
import com.amazonaws.services.elasticache.model.CacheParameterGroupStatus;
import com.amazonaws.services.elasticache.model.CacheSecurityGroupMembership;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.NotificationConfiguration;
import com.amazonaws.services.elasticache.model.PendingModifiedValues;
import com.amazonaws.services.elasticache.model.SecurityGroupMembership;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCluster
implements Serializable {
    private String cacheClusterId;
    private Endpoint configurationEndpoint;
    private String clientDownloadLandingPage;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private String cacheClusterStatus;
    private Integer numCacheNodes;
    private String preferredAvailabilityZone;
    private Date cacheClusterCreateTime;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private NotificationConfiguration notificationConfiguration;
    private ListWithAutoConstructFlag<CacheSecurityGroupMembership> cacheSecurityGroups;
    private CacheParameterGroupStatus cacheParameterGroup;
    private String cacheSubnetGroupName;
    private ListWithAutoConstructFlag<CacheNode> cacheNodes;
    private Boolean autoMinorVersionUpgrade;
    private ListWithAutoConstructFlag<SecurityGroupMembership> securityGroups;
    private String replicationGroupId;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public CacheCluster withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public Endpoint getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    public void setConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public CacheCluster withConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
        return this;
    }

    public String getClientDownloadLandingPage() {
        return this.clientDownloadLandingPage;
    }

    public void setClientDownloadLandingPage(String clientDownloadLandingPage) {
        this.clientDownloadLandingPage = clientDownloadLandingPage;
    }

    public CacheCluster withClientDownloadLandingPage(String clientDownloadLandingPage) {
        this.clientDownloadLandingPage = clientDownloadLandingPage;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public CacheCluster withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public CacheCluster withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CacheCluster withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getCacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public void setCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
    }

    public CacheCluster withCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public CacheCluster withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public CacheCluster withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
        return this;
    }

    public Date getCacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public void setCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
    }

    public CacheCluster withCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public CacheCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public CacheCluster withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public CacheCluster withNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
        return this;
    }

    public List<CacheSecurityGroupMembership> getCacheSecurityGroups() {
        if (this.cacheSecurityGroups == null) {
            this.cacheSecurityGroups = new ListWithAutoConstructFlag();
            this.cacheSecurityGroups.setAutoConstruct(true);
        }
        return this.cacheSecurityGroups;
    }

    public void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        if (cacheSecurityGroups == null) {
            this.cacheSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag cacheSecurityGroupsCopy = new ListWithAutoConstructFlag(cacheSecurityGroups.size());
        cacheSecurityGroupsCopy.addAll(cacheSecurityGroups);
        this.cacheSecurityGroups = cacheSecurityGroupsCopy;
    }

    public CacheCluster withCacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
        if (this.getCacheSecurityGroups() == null) {
            this.setCacheSecurityGroups(new ArrayList<CacheSecurityGroupMembership>(cacheSecurityGroups.length));
        }
        for (CacheSecurityGroupMembership value : cacheSecurityGroups) {
            this.getCacheSecurityGroups().add(value);
        }
        return this;
    }

    public CacheCluster withCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        if (cacheSecurityGroups == null) {
            this.cacheSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag cacheSecurityGroupsCopy = new ListWithAutoConstructFlag(cacheSecurityGroups.size());
            cacheSecurityGroupsCopy.addAll(cacheSecurityGroups);
            this.cacheSecurityGroups = cacheSecurityGroupsCopy;
        }
        return this;
    }

    public CacheParameterGroupStatus getCacheParameterGroup() {
        return this.cacheParameterGroup;
    }

    public void setCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
    }

    public CacheCluster withCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
        return this;
    }

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public CacheCluster withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
        return this;
    }

    public List<CacheNode> getCacheNodes() {
        if (this.cacheNodes == null) {
            this.cacheNodes = new ListWithAutoConstructFlag();
            this.cacheNodes.setAutoConstruct(true);
        }
        return this.cacheNodes;
    }

    public void setCacheNodes(Collection<CacheNode> cacheNodes) {
        if (cacheNodes == null) {
            this.cacheNodes = null;
            return;
        }
        ListWithAutoConstructFlag cacheNodesCopy = new ListWithAutoConstructFlag(cacheNodes.size());
        cacheNodesCopy.addAll(cacheNodes);
        this.cacheNodes = cacheNodesCopy;
    }

    public CacheCluster withCacheNodes(CacheNode ... cacheNodes) {
        if (this.getCacheNodes() == null) {
            this.setCacheNodes(new ArrayList<CacheNode>(cacheNodes.length));
        }
        for (CacheNode value : cacheNodes) {
            this.getCacheNodes().add(value);
        }
        return this;
    }

    public CacheCluster withCacheNodes(Collection<CacheNode> cacheNodes) {
        if (cacheNodes == null) {
            this.cacheNodes = null;
        } else {
            ListWithAutoConstructFlag cacheNodesCopy = new ListWithAutoConstructFlag(cacheNodes.size());
            cacheNodesCopy.addAll(cacheNodes);
            this.cacheNodes = cacheNodesCopy;
        }
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CacheCluster withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public List<SecurityGroupMembership> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ListWithAutoConstructFlag();
            this.securityGroups.setAutoConstruct(true);
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public CacheCluster withSecurityGroups(SecurityGroupMembership ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<SecurityGroupMembership>(securityGroups.length));
        }
        for (SecurityGroupMembership value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public CacheCluster withSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public CacheCluster withReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
        return this;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public CacheCluster withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
        return this;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public CacheCluster withSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: " + this.getCacheClusterId() + ",");
        }
        if (this.getConfigurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: " + this.getConfigurationEndpoint() + ",");
        }
        if (this.getClientDownloadLandingPage() != null) {
            sb.append("ClientDownloadLandingPage: " + this.getClientDownloadLandingPage() + ",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: " + this.getCacheNodeType() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getCacheClusterStatus() != null) {
            sb.append("CacheClusterStatus: " + this.getCacheClusterStatus() + ",");
        }
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: " + this.getNumCacheNodes() + ",");
        }
        if (this.getPreferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: " + this.getPreferredAvailabilityZone() + ",");
        }
        if (this.getCacheClusterCreateTime() != null) {
            sb.append("CacheClusterCreateTime: " + this.getCacheClusterCreateTime() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: " + this.getPendingModifiedValues() + ",");
        }
        if (this.getNotificationConfiguration() != null) {
            sb.append("NotificationConfiguration: " + this.getNotificationConfiguration() + ",");
        }
        if (this.getCacheSecurityGroups() != null) {
            sb.append("CacheSecurityGroups: " + this.getCacheSecurityGroups() + ",");
        }
        if (this.getCacheParameterGroup() != null) {
            sb.append("CacheParameterGroup: " + this.getCacheParameterGroup() + ",");
        }
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: " + this.getCacheSubnetGroupName() + ",");
        }
        if (this.getCacheNodes() != null) {
            sb.append("CacheNodes: " + this.getCacheNodes() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups() + ",");
        }
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: " + this.getReplicationGroupId() + ",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: " + this.getSnapshotRetentionLimit() + ",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: " + this.getSnapshotWindow());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationEndpoint() == null ? 0 : this.getConfigurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getClientDownloadLandingPage() == null ? 0 : this.getClientDownloadLandingPage().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterStatus() == null ? 0 : this.getCacheClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredAvailabilityZone() == null ? 0 : this.getPreferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterCreateTime() == null ? 0 : this.getCacheClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfiguration() == null ? 0 : this.getNotificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroups() == null ? 0 : ((Object)this.getCacheSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroup() == null ? 0 : this.getCacheParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodes() == null ? 0 : ((Object)this.getCacheNodes()).hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : ((Object)this.getSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheCluster)) {
            return false;
        }
        CacheCluster other = (CacheCluster)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getConfigurationEndpoint() == null ^ this.getConfigurationEndpoint() == null) {
            return false;
        }
        if (other.getConfigurationEndpoint() != null && !other.getConfigurationEndpoint().equals(this.getConfigurationEndpoint())) {
            return false;
        }
        if (other.getClientDownloadLandingPage() == null ^ this.getClientDownloadLandingPage() == null) {
            return false;
        }
        if (other.getClientDownloadLandingPage() != null && !other.getClientDownloadLandingPage().equals(this.getClientDownloadLandingPage())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getCacheClusterStatus() == null ^ this.getCacheClusterStatus() == null) {
            return false;
        }
        if (other.getCacheClusterStatus() != null && !other.getCacheClusterStatus().equals(this.getCacheClusterStatus())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() == null ^ this.getPreferredAvailabilityZone() == null) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() != null && !other.getPreferredAvailabilityZone().equals(this.getPreferredAvailabilityZone())) {
            return false;
        }
        if (other.getCacheClusterCreateTime() == null ^ this.getCacheClusterCreateTime() == null) {
            return false;
        }
        if (other.getCacheClusterCreateTime() != null && !other.getCacheClusterCreateTime().equals(this.getCacheClusterCreateTime())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getNotificationConfiguration() == null ^ this.getNotificationConfiguration() == null) {
            return false;
        }
        if (other.getNotificationConfiguration() != null && !other.getNotificationConfiguration().equals(this.getNotificationConfiguration())) {
            return false;
        }
        if (other.getCacheSecurityGroups() == null ^ this.getCacheSecurityGroups() == null) {
            return false;
        }
        if (other.getCacheSecurityGroups() != null && !((Object)other.getCacheSecurityGroups()).equals(this.getCacheSecurityGroups())) {
            return false;
        }
        if (other.getCacheParameterGroup() == null ^ this.getCacheParameterGroup() == null) {
            return false;
        }
        if (other.getCacheParameterGroup() != null && !other.getCacheParameterGroup().equals(this.getCacheParameterGroup())) {
            return false;
        }
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getCacheNodes() == null ^ this.getCacheNodes() == null) {
            return false;
        }
        if (other.getCacheNodes() != null && !((Object)other.getCacheNodes()).equals(this.getCacheNodes())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !((Object)other.getSecurityGroups()).equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        return other.getSnapshotWindow() == null || other.getSnapshotWindow().equals(this.getSnapshotWindow());
    }
}

