/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.InstanceCount;
import com.amazonaws.services.ec2.model.ListingStatus;
import com.amazonaws.services.ec2.model.PriceSchedule;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservedInstancesListing
implements Serializable {
    private String reservedInstancesListingId;
    private String reservedInstancesId;
    private Date createDate;
    private Date updateDate;
    private String status;
    private String statusMessage;
    private ListWithAutoConstructFlag<InstanceCount> instanceCounts;
    private ListWithAutoConstructFlag<PriceSchedule> priceSchedules;
    private ListWithAutoConstructFlag<Tag> tags;
    private String clientToken;

    public String getReservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    public void setReservedInstancesListingId(String reservedInstancesListingId) {
        this.reservedInstancesListingId = reservedInstancesListingId;
    }

    public ReservedInstancesListing withReservedInstancesListingId(String reservedInstancesListingId) {
        this.reservedInstancesListingId = reservedInstancesListingId;
        return this;
    }

    public String getReservedInstancesId() {
        return this.reservedInstancesId;
    }

    public void setReservedInstancesId(String reservedInstancesId) {
        this.reservedInstancesId = reservedInstancesId;
    }

    public ReservedInstancesListing withReservedInstancesId(String reservedInstancesId) {
        this.reservedInstancesId = reservedInstancesId;
        return this;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public ReservedInstancesListing withCreateDate(Date createDate) {
        this.createDate = createDate;
        return this;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public ReservedInstancesListing withUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ReservedInstancesListing withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(ListingStatus status) {
        this.status = status.toString();
    }

    public ReservedInstancesListing withStatus(ListingStatus status) {
        this.status = status.toString();
        return this;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public ReservedInstancesListing withStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public List<InstanceCount> getInstanceCounts() {
        if (this.instanceCounts == null) {
            this.instanceCounts = new ListWithAutoConstructFlag();
            this.instanceCounts.setAutoConstruct(true);
        }
        return this.instanceCounts;
    }

    public void setInstanceCounts(Collection<InstanceCount> instanceCounts) {
        if (instanceCounts == null) {
            this.instanceCounts = null;
            return;
        }
        ListWithAutoConstructFlag instanceCountsCopy = new ListWithAutoConstructFlag(instanceCounts.size());
        instanceCountsCopy.addAll(instanceCounts);
        this.instanceCounts = instanceCountsCopy;
    }

    public ReservedInstancesListing withInstanceCounts(InstanceCount ... instanceCounts) {
        if (this.getInstanceCounts() == null) {
            this.setInstanceCounts(new ArrayList<InstanceCount>(instanceCounts.length));
        }
        for (InstanceCount value : instanceCounts) {
            this.getInstanceCounts().add(value);
        }
        return this;
    }

    public ReservedInstancesListing withInstanceCounts(Collection<InstanceCount> instanceCounts) {
        if (instanceCounts == null) {
            this.instanceCounts = null;
        } else {
            ListWithAutoConstructFlag instanceCountsCopy = new ListWithAutoConstructFlag(instanceCounts.size());
            instanceCountsCopy.addAll(instanceCounts);
            this.instanceCounts = instanceCountsCopy;
        }
        return this;
    }

    public List<PriceSchedule> getPriceSchedules() {
        if (this.priceSchedules == null) {
            this.priceSchedules = new ListWithAutoConstructFlag();
            this.priceSchedules.setAutoConstruct(true);
        }
        return this.priceSchedules;
    }

    public void setPriceSchedules(Collection<PriceSchedule> priceSchedules) {
        if (priceSchedules == null) {
            this.priceSchedules = null;
            return;
        }
        ListWithAutoConstructFlag priceSchedulesCopy = new ListWithAutoConstructFlag(priceSchedules.size());
        priceSchedulesCopy.addAll(priceSchedules);
        this.priceSchedules = priceSchedulesCopy;
    }

    public ReservedInstancesListing withPriceSchedules(PriceSchedule ... priceSchedules) {
        if (this.getPriceSchedules() == null) {
            this.setPriceSchedules(new ArrayList<PriceSchedule>(priceSchedules.length));
        }
        for (PriceSchedule value : priceSchedules) {
            this.getPriceSchedules().add(value);
        }
        return this;
    }

    public ReservedInstancesListing withPriceSchedules(Collection<PriceSchedule> priceSchedules) {
        if (priceSchedules == null) {
            this.priceSchedules = null;
        } else {
            ListWithAutoConstructFlag priceSchedulesCopy = new ListWithAutoConstructFlag(priceSchedules.size());
            priceSchedulesCopy.addAll(priceSchedules);
            this.priceSchedules = priceSchedulesCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public ReservedInstancesListing withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public ReservedInstancesListing withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public ReservedInstancesListing withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: " + this.getReservedInstancesListingId() + ",");
        }
        if (this.getReservedInstancesId() != null) {
            sb.append("ReservedInstancesId: " + this.getReservedInstancesId() + ",");
        }
        if (this.getCreateDate() != null) {
            sb.append("CreateDate: " + this.getCreateDate() + ",");
        }
        if (this.getUpdateDate() != null) {
            sb.append("UpdateDate: " + this.getUpdateDate() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: " + this.getStatusMessage() + ",");
        }
        if (this.getInstanceCounts() != null) {
            sb.append("InstanceCounts: " + this.getInstanceCounts() + ",");
        }
        if (this.getPriceSchedules() != null) {
            sb.append("PriceSchedules: " + this.getPriceSchedules() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstancesListingId() == null ? 0 : this.getReservedInstancesListingId().hashCode());
        hashCode = 31 * hashCode + (this.getReservedInstancesId() == null ? 0 : this.getReservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.getCreateDate() == null ? 0 : this.getCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateDate() == null ? 0 : this.getUpdateDate().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCounts() == null ? 0 : ((Object)this.getInstanceCounts()).hashCode());
        hashCode = 31 * hashCode + (this.getPriceSchedules() == null ? 0 : ((Object)this.getPriceSchedules()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing)obj;
        if (other.getReservedInstancesListingId() == null ^ this.getReservedInstancesListingId() == null) {
            return false;
        }
        if (other.getReservedInstancesListingId() != null && !other.getReservedInstancesListingId().equals(this.getReservedInstancesListingId())) {
            return false;
        }
        if (other.getReservedInstancesId() == null ^ this.getReservedInstancesId() == null) {
            return false;
        }
        if (other.getReservedInstancesId() != null && !other.getReservedInstancesId().equals(this.getReservedInstancesId())) {
            return false;
        }
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) {
            return false;
        }
        if (other.getCreateDate() != null && !other.getCreateDate().equals(this.getCreateDate())) {
            return false;
        }
        if (other.getUpdateDate() == null ^ this.getUpdateDate() == null) {
            return false;
        }
        if (other.getUpdateDate() != null && !other.getUpdateDate().equals(this.getUpdateDate())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getInstanceCounts() == null ^ this.getInstanceCounts() == null) {
            return false;
        }
        if (other.getInstanceCounts() != null && !((Object)other.getInstanceCounts()).equals(this.getInstanceCounts())) {
            return false;
        }
        if (other.getPriceSchedules() == null ^ this.getPriceSchedules() == null) {
            return false;
        }
        if (other.getPriceSchedules() != null && !((Object)other.getPriceSchedules()).equals(this.getPriceSchedules())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }
}

