/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.CreateTagsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<CreateTagsRequest> {
    private ListWithAutoConstructFlag<String> resources;
    private ListWithAutoConstructFlag<Tag> tags;

    public CreateTagsRequest() {
    }

    public CreateTagsRequest(List<String> resources, List<Tag> tags) {
        this.setResources(resources);
        this.setTags(tags);
    }

    public List<String> getResources() {
        if (this.resources == null) {
            this.resources = new ListWithAutoConstructFlag();
            this.resources.setAutoConstruct(true);
        }
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        ListWithAutoConstructFlag resourcesCopy = new ListWithAutoConstructFlag(resources.size());
        resourcesCopy.addAll(resources);
        this.resources = resourcesCopy;
    }

    public CreateTagsRequest withResources(String ... resources) {
        if (this.getResources() == null) {
            this.setResources(new ArrayList<String>(resources.length));
        }
        for (String value : resources) {
            this.getResources().add(value);
        }
        return this;
    }

    public CreateTagsRequest withResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
        } else {
            ListWithAutoConstructFlag resourcesCopy = new ListWithAutoConstructFlag(resources.size());
            resourcesCopy.addAll(resources);
            this.resources = resourcesCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateTagsRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateTagsRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    @Override
    public Request<CreateTagsRequest> getDryRunRequest() {
        Request<CreateTagsRequest> request = new CreateTagsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResources() != null) {
            sb.append("Resources: " + this.getResources() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : ((Object)this.getResources()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTagsRequest)) {
            return false;
        }
        CreateTagsRequest other = (CreateTagsRequest)obj;
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !((Object)other.getResources()).equals(this.getResources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

