/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSecondaryIndex
implements Serializable {
    private String indexName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private Projection projection;
    private ProvisionedThroughput provisionedThroughput;

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public GlobalSecondaryIndex withIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
        keySchemaCopy.addAll(keySchema);
        this.keySchema = keySchemaCopy;
    }

    public GlobalSecondaryIndex withKeySchema(KeySchemaElement ... keySchema) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement value : keySchema) {
            this.getKeySchema().add(value);
        }
        return this;
    }

    public GlobalSecondaryIndex withKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
            keySchemaCopy.addAll(keySchema);
            this.keySchema = keySchemaCopy;
        }
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public GlobalSecondaryIndex withProjection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public GlobalSecondaryIndex withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexName() != null) {
            sb.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getProjection() != null) {
            sb.append("Projection: " + this.getProjection() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: " + this.getProvisionedThroughput());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        hashCode = 31 * hashCode + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndex)) {
            return false;
        }
        GlobalSecondaryIndex other = (GlobalSecondaryIndex)obj;
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !((Object)other.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (other.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        if (other.getProjection() != null && !other.getProjection().equals(this.getProjection())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        return other.getProvisionedThroughput() == null || other.getProvisionedThroughput().equals(this.getProvisionedThroughput());
    }
}

