/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.Capacity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumedCapacity
implements Serializable {
    private String tableName;
    private Double capacityUnits;
    private Capacity table;
    private Map<String, Capacity> localSecondaryIndexes;
    private Map<String, Capacity> globalSecondaryIndexes;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ConsumedCapacity withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Double getCapacityUnits() {
        return this.capacityUnits;
    }

    public void setCapacityUnits(Double capacityUnits) {
        this.capacityUnits = capacityUnits;
    }

    public ConsumedCapacity withCapacityUnits(Double capacityUnits) {
        this.capacityUnits = capacityUnits;
        return this;
    }

    public Capacity getTable() {
        return this.table;
    }

    public void setTable(Capacity table) {
        this.table = table;
    }

    public ConsumedCapacity withTable(Capacity table) {
        this.table = table;
        return this;
    }

    public Map<String, Capacity> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Map<String, Capacity> localSecondaryIndexes) {
        this.localSecondaryIndexes = localSecondaryIndexes;
    }

    public ConsumedCapacity withLocalSecondaryIndexes(Map<String, Capacity> localSecondaryIndexes) {
        this.setLocalSecondaryIndexes(localSecondaryIndexes);
        return this;
    }

    public ConsumedCapacity addLocalSecondaryIndexesEntry(String key, Capacity value) {
        if (null == this.localSecondaryIndexes) {
            this.localSecondaryIndexes = new HashMap<String, Capacity>();
        }
        if (this.localSecondaryIndexes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.localSecondaryIndexes.put(key, value);
        return this;
    }

    public ConsumedCapacity clearLocalSecondaryIndexesEntries() {
        this.localSecondaryIndexes = null;
        return this;
    }

    public Map<String, Capacity> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Map<String, Capacity> globalSecondaryIndexes) {
        this.globalSecondaryIndexes = globalSecondaryIndexes;
    }

    public ConsumedCapacity withGlobalSecondaryIndexes(Map<String, Capacity> globalSecondaryIndexes) {
        this.setGlobalSecondaryIndexes(globalSecondaryIndexes);
        return this;
    }

    public ConsumedCapacity addGlobalSecondaryIndexesEntry(String key, Capacity value) {
        if (null == this.globalSecondaryIndexes) {
            this.globalSecondaryIndexes = new HashMap<String, Capacity>();
        }
        if (this.globalSecondaryIndexes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.globalSecondaryIndexes.put(key, value);
        return this;
    }

    public ConsumedCapacity clearGlobalSecondaryIndexesEntries() {
        this.globalSecondaryIndexes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getCapacityUnits() != null) {
            sb.append("CapacityUnits: " + this.getCapacityUnits() + ",");
        }
        if (this.getTable() != null) {
            sb.append("Table: " + this.getTable() + ",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: " + this.getLocalSecondaryIndexes() + ",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: " + this.getGlobalSecondaryIndexes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityUnits() == null ? 0 : this.getCapacityUnits().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getLocalSecondaryIndexes() == null ? 0 : ((Object)this.getLocalSecondaryIndexes()).hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexes() == null ? 0 : ((Object)this.getGlobalSecondaryIndexes()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumedCapacity)) {
            return false;
        }
        ConsumedCapacity other = (ConsumedCapacity)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getCapacityUnits() == null ^ this.getCapacityUnits() == null) {
            return false;
        }
        if (other.getCapacityUnits() != null && !other.getCapacityUnits().equals(this.getCapacityUnits())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() != null && !((Object)other.getLocalSecondaryIndexes()).equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        return other.getGlobalSecondaryIndexes() == null || ((Object)other.getGlobalSecondaryIndexes()).equals(this.getGlobalSecondaryIndexes());
    }
}

