/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStatusRequestMarshaller
implements Marshaller<Request<SetStatusRequest>, SetStatusRequest> {
    @Override
    public Request<SetStatusRequest> marshall(SetStatusRequest setStatusRequest) {
        if (setStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetStatusRequest> request = new DefaultRequest<SetStatusRequest>(setStatusRequest, "DataPipeline");
        String target = "DataPipeline.SetStatus";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag objectIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (setStatusRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(setStatusRequest.getPipelineId());
            }
            if (!((objectIdsList = (ListWithAutoConstructFlag)setStatusRequest.getObjectIds()) == null || objectIdsList.isAutoConstruct() && objectIdsList.isEmpty())) {
                jsonWriter.key("objectIds");
                jsonWriter.array();
                for (String objectIdsListValue : objectIdsList) {
                    if (objectIdsListValue == null) continue;
                    jsonWriter.value(objectIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (setStatusRequest.getStatus() != null) {
                jsonWriter.key("status").value(setStatusRequest.getStatus());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

