/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.Statistic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMetricStatisticsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String namespace;
    private String metricName;
    private ListWithAutoConstructFlag<Dimension> dimensions;
    private Date startTime;
    private Date endTime;
    private Integer period;
    private ListWithAutoConstructFlag<String> statistics;
    private String unit;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public GetMetricStatisticsRequest withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public GetMetricStatisticsRequest withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new ListWithAutoConstructFlag();
            this.dimensions.setAutoConstruct(true);
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
        dimensionsCopy.addAll(dimensions);
        this.dimensions = dimensionsCopy;
    }

    public GetMetricStatisticsRequest withDimensions(Dimension ... dimensions) {
        if (this.getDimensions() == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension value : dimensions) {
            this.getDimensions().add(value);
        }
        return this;
    }

    public GetMetricStatisticsRequest withDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
        } else {
            ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
            dimensionsCopy.addAll(dimensions);
            this.dimensions = dimensionsCopy;
        }
        return this;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public GetMetricStatisticsRequest withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public GetMetricStatisticsRequest withEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public GetMetricStatisticsRequest withPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public List<String> getStatistics() {
        if (this.statistics == null) {
            this.statistics = new ListWithAutoConstructFlag();
            this.statistics.setAutoConstruct(true);
        }
        return this.statistics;
    }

    public void setStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        ListWithAutoConstructFlag statisticsCopy = new ListWithAutoConstructFlag(statistics.size());
        statisticsCopy.addAll(statistics);
        this.statistics = statisticsCopy;
    }

    public GetMetricStatisticsRequest withStatistics(String ... statistics) {
        if (this.getStatistics() == null) {
            this.setStatistics(new ArrayList<String>(statistics.length));
        }
        for (String value : statistics) {
            this.getStatistics().add(value);
        }
        return this;
    }

    public GetMetricStatisticsRequest withStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
        } else {
            ListWithAutoConstructFlag statisticsCopy = new ListWithAutoConstructFlag(statistics.size());
            statisticsCopy.addAll(statistics);
            this.statistics = statisticsCopy;
        }
        return this;
    }

    public GetMetricStatisticsRequest withStatistics(Statistic ... statistics) {
        ArrayList<String> statisticsCopy = new ArrayList<String>(statistics.length);
        for (Statistic member : statistics) {
            statisticsCopy.add(member.toString());
        }
        if (this.getStatistics() == null) {
            this.setStatistics(statisticsCopy);
        } else {
            this.getStatistics().addAll(statisticsCopy);
        }
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public GetMetricStatisticsRequest withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public void setUnit(StandardUnit unit) {
        this.unit = unit.toString();
    }

    public GetMetricStatisticsRequest withUnit(StandardUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: " + this.getMetricName() + ",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: " + this.getDimensions() + ",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: " + this.getPeriod() + ",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: " + this.getStatistics() + ",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: " + this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : ((Object)this.getDimensions()).hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : ((Object)this.getStatistics()).hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsRequest)) {
            return false;
        }
        GetMetricStatisticsRequest other = (GetMetricStatisticsRequest)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !((Object)other.getDimensions()).equals(this.getDimensions())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !((Object)other.getStatistics()).equals(this.getStatistics())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }
}

