/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeSuggestersRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private ListWithAutoConstructFlag<String> suggesterNames;
    private Boolean deployed;

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DescribeSuggestersRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<String> getSuggesterNames() {
        if (this.suggesterNames == null) {
            this.suggesterNames = new ListWithAutoConstructFlag();
            this.suggesterNames.setAutoConstruct(true);
        }
        return this.suggesterNames;
    }

    public void setSuggesterNames(Collection<String> suggesterNames) {
        if (suggesterNames == null) {
            this.suggesterNames = null;
            return;
        }
        ListWithAutoConstructFlag suggesterNamesCopy = new ListWithAutoConstructFlag(suggesterNames.size());
        suggesterNamesCopy.addAll(suggesterNames);
        this.suggesterNames = suggesterNamesCopy;
    }

    public DescribeSuggestersRequest withSuggesterNames(String ... suggesterNames) {
        if (this.getSuggesterNames() == null) {
            this.setSuggesterNames(new ArrayList<String>(suggesterNames.length));
        }
        for (String value : suggesterNames) {
            this.getSuggesterNames().add(value);
        }
        return this;
    }

    public DescribeSuggestersRequest withSuggesterNames(Collection<String> suggesterNames) {
        if (suggesterNames == null) {
            this.suggesterNames = null;
        } else {
            ListWithAutoConstructFlag suggesterNamesCopy = new ListWithAutoConstructFlag(suggesterNames.size());
            suggesterNamesCopy.addAll(suggesterNames);
            this.suggesterNames = suggesterNamesCopy;
        }
        return this;
    }

    public Boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(Boolean deployed) {
        this.deployed = deployed;
    }

    public DescribeSuggestersRequest withDeployed(Boolean deployed) {
        this.deployed = deployed;
        return this;
    }

    public Boolean getDeployed() {
        return this.deployed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getSuggesterNames() != null) {
            sb.append("SuggesterNames: " + this.getSuggesterNames() + ",");
        }
        if (this.isDeployed() != null) {
            sb.append("Deployed: " + this.isDeployed());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getSuggesterNames() == null ? 0 : ((Object)this.getSuggesterNames()).hashCode());
        hashCode = 31 * hashCode + (this.isDeployed() == null ? 0 : this.isDeployed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSuggestersRequest)) {
            return false;
        }
        DescribeSuggestersRequest other = (DescribeSuggestersRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getSuggesterNames() == null ^ this.getSuggesterNames() == null) {
            return false;
        }
        if (other.getSuggesterNames() != null && !((Object)other.getSuggesterNames()).equals(this.getSuggesterNames())) {
            return false;
        }
        if (other.isDeployed() == null ^ this.isDeployed() == null) {
            return false;
        }
        return other.isDeployed() == null || other.isDeployed().equals(this.isDeployed());
    }
}

