/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackStatus;
import com.amazonaws.services.cloudformation.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack
implements Serializable {
    private String stackId;
    private String stackName;
    private String description;
    private ListWithAutoConstructFlag<Parameter> parameters;
    private Date creationTime;
    private Date lastUpdatedTime;
    private String stackStatus;
    private String stackStatusReason;
    private Boolean disableRollback;
    private ListWithAutoConstructFlag<String> notificationARNs;
    private Integer timeoutInMinutes;
    private ListWithAutoConstructFlag<String> capabilities;
    private ListWithAutoConstructFlag<Output> outputs;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public Stack withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public Stack withStackName(String stackName) {
        this.stackName = stackName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Stack withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ListWithAutoConstructFlag();
            this.parameters.setAutoConstruct(true);
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public Stack withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public Stack withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Stack withCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Stack withLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    public String getStackStatus() {
        return this.stackStatus;
    }

    public void setStackStatus(String stackStatus) {
        this.stackStatus = stackStatus;
    }

    public Stack withStackStatus(String stackStatus) {
        this.stackStatus = stackStatus;
        return this;
    }

    public void setStackStatus(StackStatus stackStatus) {
        this.stackStatus = stackStatus.toString();
    }

    public Stack withStackStatus(StackStatus stackStatus) {
        this.stackStatus = stackStatus.toString();
        return this;
    }

    public String getStackStatusReason() {
        return this.stackStatusReason;
    }

    public void setStackStatusReason(String stackStatusReason) {
        this.stackStatusReason = stackStatusReason;
    }

    public Stack withStackStatusReason(String stackStatusReason) {
        this.stackStatusReason = stackStatusReason;
        return this;
    }

    public Boolean isDisableRollback() {
        return this.disableRollback;
    }

    public void setDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public Stack withDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
        return this;
    }

    public Boolean getDisableRollback() {
        return this.disableRollback;
    }

    public List<String> getNotificationARNs() {
        if (this.notificationARNs == null) {
            this.notificationARNs = new ListWithAutoConstructFlag();
            this.notificationARNs.setAutoConstruct(true);
        }
        return this.notificationARNs;
    }

    public void setNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
            return;
        }
        ListWithAutoConstructFlag notificationARNsCopy = new ListWithAutoConstructFlag(notificationARNs.size());
        notificationARNsCopy.addAll(notificationARNs);
        this.notificationARNs = notificationARNsCopy;
    }

    public Stack withNotificationARNs(String ... notificationARNs) {
        if (this.getNotificationARNs() == null) {
            this.setNotificationARNs(new ArrayList<String>(notificationARNs.length));
        }
        for (String value : notificationARNs) {
            this.getNotificationARNs().add(value);
        }
        return this;
    }

    public Stack withNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
        } else {
            ListWithAutoConstructFlag notificationARNsCopy = new ListWithAutoConstructFlag(notificationARNs.size());
            notificationARNsCopy.addAll(notificationARNs);
            this.notificationARNs = notificationARNsCopy;
        }
        return this;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Stack withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ListWithAutoConstructFlag();
            this.capabilities.setAutoConstruct(true);
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        ListWithAutoConstructFlag capabilitiesCopy = new ListWithAutoConstructFlag(capabilities.size());
        capabilitiesCopy.addAll(capabilities);
        this.capabilities = capabilitiesCopy;
    }

    public Stack withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public Stack withCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
        } else {
            ListWithAutoConstructFlag capabilitiesCopy = new ListWithAutoConstructFlag(capabilities.size());
            capabilitiesCopy.addAll(capabilities);
            this.capabilities = capabilitiesCopy;
        }
        return this;
    }

    public Stack withCapabilities(Capability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (Capability member : capabilities) {
            capabilitiesCopy.add(member.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public List<Output> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new ListWithAutoConstructFlag();
            this.outputs.setAutoConstruct(true);
        }
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        ListWithAutoConstructFlag outputsCopy = new ListWithAutoConstructFlag(outputs.size());
        outputsCopy.addAll(outputs);
        this.outputs = outputsCopy;
    }

    public Stack withOutputs(Output ... outputs) {
        if (this.getOutputs() == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output value : outputs) {
            this.getOutputs().add(value);
        }
        return this;
    }

    public Stack withOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
        } else {
            ListWithAutoConstructFlag outputsCopy = new ListWithAutoConstructFlag(outputs.size());
            outputsCopy.addAll(outputs);
            this.outputs = outputsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Stack withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Stack withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getStackName() != null) {
            sb.append("StackName: " + this.getStackName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: " + this.getCreationTime() + ",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: " + this.getLastUpdatedTime() + ",");
        }
        if (this.getStackStatus() != null) {
            sb.append("StackStatus: " + this.getStackStatus() + ",");
        }
        if (this.getStackStatusReason() != null) {
            sb.append("StackStatusReason: " + this.getStackStatusReason() + ",");
        }
        if (this.isDisableRollback() != null) {
            sb.append("DisableRollback: " + this.isDisableRollback() + ",");
        }
        if (this.getNotificationARNs() != null) {
            sb.append("NotificationARNs: " + this.getNotificationARNs() + ",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: " + this.getTimeoutInMinutes() + ",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: " + this.getCapabilities() + ",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: " + this.getOutputs() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getStackStatus() == null ? 0 : this.getStackStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStackStatusReason() == null ? 0 : this.getStackStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.isDisableRollback() == null ? 0 : this.isDisableRollback().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationARNs() == null ? 0 : ((Object)this.getNotificationARNs()).hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : ((Object)this.getCapabilities()).hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : ((Object)this.getOutputs()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !((Object)other.getParameters()).equals(this.getParameters())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getStackStatus() == null ^ this.getStackStatus() == null) {
            return false;
        }
        if (other.getStackStatus() != null && !other.getStackStatus().equals(this.getStackStatus())) {
            return false;
        }
        if (other.getStackStatusReason() == null ^ this.getStackStatusReason() == null) {
            return false;
        }
        if (other.getStackStatusReason() != null && !other.getStackStatusReason().equals(this.getStackStatusReason())) {
            return false;
        }
        if (other.isDisableRollback() == null ^ this.isDisableRollback() == null) {
            return false;
        }
        if (other.isDisableRollback() != null && !other.isDisableRollback().equals(this.isDisableRollback())) {
            return false;
        }
        if (other.getNotificationARNs() == null ^ this.getNotificationARNs() == null) {
            return false;
        }
        if (other.getNotificationARNs() != null && !((Object)other.getNotificationARNs()).equals(this.getNotificationARNs())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !((Object)other.getCapabilities()).equals(this.getCapabilities())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !((Object)other.getOutputs()).equals(this.getOutputs())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

