/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public final class MemoryUtils {
    private static Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    public static final int LONG_NUM_BYTES = 8;
    public static final int INT_NUM_BYTES = 4;
    public static final int SHORT_NUM_BYTES = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static short getShort(byte[] data, int index) {
        if (!($assertionsDisabled || index >= 0 && index + 2 <= data.length)) {
            throw new AssertionError();
        }
        return UNSAFE.getShort(data, BYTE_ARRAY_OFFSET + (long)index);
    }

    public static int getInt(byte[] data, int index) {
        if (!($assertionsDisabled || index >= 0 && index + 4 <= data.length)) {
            throw new AssertionError();
        }
        return UNSAFE.getInt(data, BYTE_ARRAY_OFFSET + (long)index);
    }

    public static long getLong(byte[] data, int index) {
        if (!($assertionsDisabled || index >= 0 && index + 8 <= data.length)) {
            throw new AssertionError();
        }
        return UNSAFE.getLong(data, BYTE_ARRAY_OFFSET + (long)index);
    }

    public static void putShort(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        if (!($assertionsDisabled || srcIndex >= 0 && srcIndex + 2 <= src.length)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || destIndex >= 0 && destIndex + 2 <= dest.length)) {
            throw new AssertionError();
        }
        short value = UNSAFE.getShort(src, BYTE_ARRAY_OFFSET + (long)srcIndex);
        UNSAFE.putShort(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    public static void putInt(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        if (!($assertionsDisabled || srcIndex >= 0 && srcIndex + 4 <= src.length)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || destIndex >= 0 && destIndex + 4 <= dest.length)) {
            throw new AssertionError();
        }
        int value = UNSAFE.getInt(src, BYTE_ARRAY_OFFSET + (long)srcIndex);
        UNSAFE.putInt(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    public static void putLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        if (!($assertionsDisabled || srcIndex >= 0 && srcIndex + 8 <= src.length)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || destIndex >= 0 && destIndex + 8 <= dest.length)) {
            throw new AssertionError();
        }
        long value = UNSAFE.getLong(src, BYTE_ARRAY_OFFSET + (long)srcIndex);
        UNSAFE.putLong(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    public static void putShort(byte[] dest, int destIndex, short value) {
        if (!($assertionsDisabled || destIndex >= 0 && destIndex + 2 <= dest.length)) {
            throw new AssertionError();
        }
        UNSAFE.putShort(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    public static void putInt(byte[] dest, int destIndex, int value) {
        if (!($assertionsDisabled || destIndex >= 0 && destIndex + 4 <= dest.length)) {
            throw new AssertionError();
        }
        UNSAFE.putInt(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    public static void putLong(byte[] dest, int destIndex, long value) {
        if (!($assertionsDisabled || destIndex >= 0 && destIndex + 8 <= dest.length)) {
            throw new AssertionError();
        }
        UNSAFE.putLong(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    private MemoryUtils() {
    }

    static {
        boolean bl = $assertionsDisabled = !MemoryUtils.class.desiredAssertionStatus();
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalStateException("Drill only runs on LittleEndian systems.");
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

