/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Set;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.ZeroVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;
import oadd.org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionListReader;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionListWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public class ListVector
extends BaseRepeatedValueVector {
    private UInt4Vector offsets;
    private final UInt1Vector bits;
    private Mutator mutator = new Mutator();
    private Accessor accessor = new Accessor();
    private UnionListWriter writer;
    private UnionListReader reader;
    private CallBack callBack;
    private int lastSet;

    public ListVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        super(field, allocator);
        this.bits = new UInt1Vector(MaterializedField.create("$bits$", Types.required(TypeProtos.MinorType.UINT1)), allocator);
        this.offsets = this.getOffsetVector();
        this.field.addChild(this.getDataVector().getField());
        this.writer = new UnionListWriter(this);
        this.reader = new UnionListReader(this);
        this.callBack = callBack;
    }

    public UnionListWriter getWriter() {
        return this.writer;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        super.allocateNewSafe();
        this.bits.allocateNewSafe();
    }

    public void transferTo(ListVector target) {
        this.offsets.makeTransferPair(target.offsets).transfer();
        this.bits.makeTransferPair(target.bits).transfer();
        if (target.getDataVector() instanceof ZeroVector) {
            target.addOrGetVector(new VectorDescriptor(this.vector.getField().getType()));
        }
        this.getDataVector().makeTransferPair(target.getDataVector()).transfer();
    }

    public void copyFromSafe(int inIndex, int outIndex, ListVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    public void copyFrom(int inIndex, int outIndex, ListVector from) {
        FieldReader in = from.getReader();
        in.setPosition(inIndex);
        UnionListWriter out = this.getWriter();
        out.setPosition(outIndex);
        ComplexCopier.copy(in, out);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (ListVector)from);
    }

    @Override
    public ValueVector getDataVector() {
        return this.vector;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.field.withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((ListVector)target);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = this.vector.allocateNewSafe();
            success = success && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        if (success) {
            this.offsets.zeroVector();
            this.bits.zeroVector();
        }
        return success;
    }

    @Override
    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return this.getField().getAsBuilder().setValueCount(this.getAccessor().getValueCount()).setBufferLength(this.getBufferSize()).addChild(this.offsets.getMetadata()).addChild(this.bits.getMetadata()).addChild(this.vector.getMetadata());
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult result = super.addOrGetVector(descriptor);
        this.reader = new UnionListReader(this);
        return result;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.offsets.getBufferSize() + this.bits.getBufferSize() + this.vector.getBufferSize();
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.vector.clear();
        this.bits.clear();
        this.lastSet = 0;
        super.clear();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsets.getBuffers(false), ObjectArrays.concat(this.bits.getBuffers(false), this.vector.getBuffers(false), DrillBuf.class), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain();
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        UserBitShared.SerializedField offsetMetadata = metadata.getChild(0);
        this.offsets.load(offsetMetadata, buffer);
        int offsetLength = offsetMetadata.getBufferLength();
        UserBitShared.SerializedField bitMetadata = metadata.getChild(1);
        int bitLength = bitMetadata.getBufferLength();
        this.bits.load(bitMetadata, buffer.slice(offsetLength, bitLength));
        UserBitShared.SerializedField vectorMetadata = metadata.getChild(2);
        if (this.getDataVector() == DEFAULT_DATA_VECTOR) {
            this.addOrGetVector(VectorDescriptor.create(vectorMetadata.getMajorType()));
        }
        int vectorLength = vectorMetadata.getBufferLength();
        this.vector.load(vectorMetadata, buffer.slice(offsetLength + bitLength, vectorLength));
    }

    public UnionVector promoteToUnion() {
        MaterializedField newField = MaterializedField.create(this.getField().getName(), Types.optional(TypeProtos.MinorType.UNION));
        UnionVector vector = new UnionVector(newField, this.allocator, null);
        this.replaceDataVector(vector);
        this.reader = new UnionListReader(this);
        return vector;
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.offsets.collectLedgers(ledgers);
        this.bits.collectLedgers(ledgers);
        super.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.offsets.getPayloadByteCount(valueCount) + this.bits.getPayloadByteCount(valueCount) + super.getPayloadByteCount(valueCount);
    }

    public class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator {
        public Mutator() {
            super(ListVector.this);
        }

        public void setNotNull(int index) {
            ListVector.this.bits.getMutator().setSafe(index, 1);
            ListVector.this.lastSet = index + 1;
        }

        @Override
        public void startNewValue(int index) {
            for (int i = ListVector.this.lastSet; i <= index; ++i) {
                ListVector.this.offsets.getMutator().setSafe(i + 1, ListVector.this.offsets.getAccessor().get(i));
            }
            this.setNotNull(index);
            ListVector.this.lastSet = index + 1;
        }

        @Override
        public void setValueCount(int valueCount) {
            if (valueCount == 0) {
                ListVector.this.offsets.getMutator().setValueCount(0);
            } else {
                for (int i = ListVector.this.lastSet; i < valueCount; ++i) {
                    ListVector.this.offsets.getMutator().setSafe(i + 1, ListVector.this.offsets.getAccessor().get(i));
                }
                ListVector.this.offsets.getMutator().setValueCount(valueCount + 1);
            }
            int childValueCount = valueCount == 0 ? 0 : ListVector.this.offsets.getAccessor().get(valueCount);
            ListVector.this.vector.getMutator().setValueCount(childValueCount);
            ListVector.this.bits.getMutator().setValueCount(valueCount);
        }
    }

    public class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(ListVector.this);
        }

        @Override
        public Object getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            JsonStringArrayList<Object> vals = new JsonStringArrayList<Object>();
            UInt4Vector.Accessor offsetsAccessor = ListVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            ValueVector.Accessor valuesAccessor = ListVector.this.getDataVector().getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        @Override
        public boolean isNull(int index) {
            return ListVector.this.bits.getAccessor().get(index) == 0;
        }
    }

    private class TransferImpl
    implements TransferPair {
        ListVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new ListVector(field, allocator, null);
            this.to.addOrGetVector(new VectorDescriptor(ListVector.this.vector.getField().getType()));
        }

        public TransferImpl(ListVector to) {
            this.to = to;
            to.addOrGetVector(new VectorDescriptor(ListVector.this.vector.getField().getType()));
        }

        @Override
        public void transfer() {
            ListVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.to.allocateNew();
            for (int i = 0; i < length; ++i) {
                this.copyValueSafe(startIndex + i, i);
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, ListVector.this);
        }
    }
}

