/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.impl;

import java.math.BigDecimal;
import oadd.org.apache.drill.exec.vector.accessor.AccessorUtilities;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnAccessor;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleAccessor;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractColumnWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractTupleAccessor;
import oadd.org.joda.time.Period;

public class TupleWriterImpl
extends AbstractTupleAccessor
implements TupleWriter {
    private final AbstractColumnWriter[] writers;

    public TupleWriterImpl(TupleAccessor.TupleSchema schema, AbstractColumnWriter[] writers) {
        super(schema);
        this.writers = writers;
    }

    public void start() {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].start();
        }
    }

    @Override
    public ColumnWriter column(int colIndex) {
        return this.writers[colIndex];
    }

    @Override
    public ColumnWriter column(String colName) {
        int index = this.schema.columnIndex(colName);
        if (index == -1) {
            return null;
        }
        return this.writers[index];
    }

    @Override
    public void set(int colIndex, Object value) {
        ColumnWriter colWriter = this.column(colIndex);
        if (value == null) {
            if (colWriter.valueType() != ColumnAccessor.ValueType.ARRAY) {
                colWriter.setNull();
            }
        } else if (value instanceof Integer) {
            colWriter.setInt((Integer)value);
        } else if (value instanceof Long) {
            colWriter.setLong((Long)value);
        } else if (value instanceof String) {
            colWriter.setString((String)value);
        } else if (value instanceof BigDecimal) {
            colWriter.setDecimal((BigDecimal)value);
        } else if (value instanceof Period) {
            colWriter.setPeriod((Period)value);
        } else if (value instanceof byte[]) {
            colWriter.setBytes((byte[])value);
        } else if (value instanceof Byte) {
            colWriter.setInt(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            colWriter.setInt(((Short)value).shortValue());
        } else if (value instanceof Double) {
            colWriter.setDouble((Double)value);
        } else if (value instanceof Float) {
            colWriter.setDouble(((Float)value).floatValue());
        } else if (value.getClass().getName().startsWith("[")) {
            this.setArray(colIndex, value);
        } else {
            throw new IllegalArgumentException("Unsupported type " + value.getClass().getSimpleName() + " for column " + colIndex);
        }
    }

    public void setArray(int colIndex, Object value) {
        if (value == null) {
            return;
        }
        String objClass = value.getClass().getName();
        if (!objClass.startsWith("[")) {
            throw new IllegalArgumentException("Argument is not an array");
        }
        ColumnWriter colWriter = this.column(colIndex);
        if (colWriter.valueType() != ColumnAccessor.ValueType.ARRAY) {
            throw new IllegalArgumentException("Column is not an array");
        }
        ArrayWriter arrayWriter = colWriter.array();
        char second = objClass.charAt(1);
        switch (second) {
            case 'B': {
                AccessorUtilities.setByteArray(arrayWriter, (byte[])value);
                break;
            }
            case 'S': {
                AccessorUtilities.setShortArray(arrayWriter, (short[])value);
                break;
            }
            case 'I': {
                AccessorUtilities.setIntArray(arrayWriter, (int[])value);
                break;
            }
            case 'J': {
                AccessorUtilities.setLongArray(arrayWriter, (long[])value);
                break;
            }
            case 'F': {
                AccessorUtilities.setFloatArray(arrayWriter, (float[])value);
                break;
            }
            case 'D': {
                AccessorUtilities.setDoubleArray(arrayWriter, (double[])value);
                break;
            }
            case 'Z': {
                AccessorUtilities.setBooleanArray(arrayWriter, (boolean[])value);
                break;
            }
            case 'L': {
                int posn = objClass.indexOf(59);
                String memberClassName = objClass.substring(2, posn);
                if (memberClassName.equals(String.class.getName())) {
                    AccessorUtilities.setStringArray(arrayWriter, (String[])value);
                    break;
                }
                if (memberClassName.equals(Period.class.getName())) {
                    AccessorUtilities.setPeriodArray(arrayWriter, (Period[])value);
                    break;
                }
                if (memberClassName.equals(BigDecimal.class.getName())) {
                    AccessorUtilities.setBigDecimalArray(arrayWriter, (BigDecimal[])value);
                    break;
                }
                throw new IllegalArgumentException("Unknown Java array type: " + memberClassName);
            }
            default: {
                throw new IllegalArgumentException("Unknown Java array type: " + second);
            }
        }
    }
}

