/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.impl;

import oadd.org.apache.drill.exec.vector.accessor.ArrayReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.TupleAccessor;
import oadd.org.apache.drill.exec.vector.accessor.TupleReader;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractTupleAccessor;

public class TupleReaderImpl
extends AbstractTupleAccessor
implements TupleReader {
    private final AbstractColumnReader[] readers;

    public TupleReaderImpl(TupleAccessor.TupleSchema schema, AbstractColumnReader[] readers) {
        super(schema);
        this.readers = readers;
    }

    @Override
    public ColumnReader column(int colIndex) {
        return this.readers[colIndex];
    }

    @Override
    public ColumnReader column(String colName) {
        int index = this.schema.columnIndex(colName);
        if (index == -1) {
            return null;
        }
        return this.readers[index];
    }

    @Override
    public Object get(int colIndex) {
        ColumnReader colReader = this.column(colIndex);
        if (colReader.isNull()) {
            return null;
        }
        switch (colReader.valueType()) {
            case BYTES: {
                return colReader.getBytes();
            }
            case DOUBLE: {
                return colReader.getDouble();
            }
            case INTEGER: {
                return colReader.getInt();
            }
            case LONG: {
                return colReader.getLong();
            }
            case STRING: {
                return colReader.getString();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)colReader.valueType()));
    }

    @Override
    public String getAsString(int colIndex) {
        ColumnReader colReader = this.column(colIndex);
        if (colReader.isNull()) {
            return "null";
        }
        switch (colReader.valueType()) {
            case BYTES: {
                return this.bytesToString(colReader.getBytes());
            }
            case DOUBLE: {
                return Double.toString(colReader.getDouble());
            }
            case INTEGER: {
                return Integer.toString(colReader.getInt());
            }
            case LONG: {
                return Long.toString(colReader.getLong());
            }
            case STRING: {
                return "\"" + colReader.getString() + "\"";
            }
            case DECIMAL: {
                return colReader.getDecimal().toPlainString();
            }
            case ARRAY: {
                return this.getArrayAsString(colReader.array());
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)colReader.valueType()));
    }

    private String bytesToString(byte[] value) {
        StringBuilder buf = new StringBuilder().append("[");
        int len = Math.min(value.length, 20);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(value[i]);
        }
        if (value.length > len) {
            buf.append("...");
        }
        buf.append("]");
        return buf.toString();
    }

    private String getArrayAsString(ArrayReader array) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        block9: for (int i = 0; i < array.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            switch (array.valueType()) {
                case BYTES: {
                    buf.append(this.bytesToString(array.getBytes(i)));
                    continue block9;
                }
                case DOUBLE: {
                    buf.append(Double.toString(array.getDouble(i)));
                    continue block9;
                }
                case INTEGER: {
                    buf.append(Integer.toString(array.getInt(i)));
                    continue block9;
                }
                case LONG: {
                    buf.append(Long.toString(array.getLong(i)));
                    continue block9;
                }
                case STRING: {
                    buf.append("\"" + array.getString(i) + "\"");
                    continue block9;
                }
                case DECIMAL: {
                    buf.append(array.getDecimal(i).toPlainString());
                    continue block9;
                }
                case ARRAY: 
                case MAP: {
                    throw new UnsupportedOperationException("Unsupported type " + (Object)((Object)array.valueType()));
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type " + (Object)((Object)array.valueType()));
                }
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

