/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.UntypedNullHolder;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UntypedNullVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(UntypedNullVector.class);
    public static final int VALUE_WIDTH = 0;
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int valueCount = 0;

    public UntypedNullVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public int getValueCapacity() {
        return 65536;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
    }

    @Override
    public void allocateNew() {
    }

    @Override
    public boolean allocateNewSafe() {
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void zeroVector() {
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 0;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.valueCount = valueCount;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UntypedNullVector)to);
    }

    public void transferTo(UntypedNullVector target) {
    }

    public void splitAndTransferTo(int startIndex, int length, UntypedNullVector target) {
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return 0;
    }

    public void copyFrom(int fromIndex, int thisIndex, UntypedNullVector from) {
    }

    public void copyFromSafe(int fromIndex, int thisIndex, UntypedNullVector from) {
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this.valueCount) {
            throw new IndexOutOfBoundsException(String.format("index: %d, expected: range(0, %d-1))", index, this.valueCount));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        ((UntypedNullVector)from).data.getBytes(fromIndex * 4, this.data, toIndex * 4, 4);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support set");
        }

        public void set(int index, int isSet, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support set");
        }

        public void setSafe(int index, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support setSafe");
        }

        public void setSafe(int index, int isSet, UntypedNullHolder holder) {
            throw new UnsupportedOperationException("UntypedNullVector does not support setSafe");
        }

        public void setScalar(int index, UntypedNullHolder holder) throws VectorOverflowException {
            throw new UnsupportedOperationException("UntypedNullVector does not support setScalar");
        }

        public void setArrayItem(int index, UntypedNullHolder holder) throws VectorOverflowException {
            throw new UnsupportedOperationException("UntypedNullVector does not support setArrayItem");
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
        }

        @Override
        public void setValueCount(int valueCount) {
            UntypedNullVector.this.valueCount = valueCount;
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return UntypedNullVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            UntypedNullVector.this.checkBounds(index);
            return true;
        }

        public int isSet(int index) {
            UntypedNullVector.this.checkBounds(index);
            return 0;
        }

        @Override
        public Object getObject(int index) {
            UntypedNullVector.this.checkBounds(index);
            return null;
        }

        public void get(int index, UntypedNullHolder holder) {
            UntypedNullVector.this.checkBounds(index);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private UntypedNullVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new UntypedNullVector(field, allocator);
        }

        public TransferImpl(UntypedNullVector to) {
            this.to = to;
        }

        @Override
        public UntypedNullVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UntypedNullVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            UntypedNullVector.this.checkBounds(startIndex);
            UntypedNullVector.this.checkBounds(startIndex + length - 1);
            UntypedNullVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            UntypedNullVector.this.checkBounds(fromIndex);
            this.to.copyFromSafe(fromIndex, toIndex, UntypedNullVector.this);
        }
    }
}

