/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt1Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.UInt1ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UInt1Vector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(UInt1Vector.class);
    public static final int VALUE_WIDTH = 1;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 1;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 1 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new UInt1ReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(4096, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public UInt1Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 1;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 1;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 1L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 1);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        long l = newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0L) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 1;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UInt1Vector)to);
    }

    public void transferTo(UInt1Vector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, UInt1Vector target) {
        int startPoint = startIndex * 1;
        int sliceLength = length * 1;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 1;
    }

    public void copyFrom(int fromIndex, int thisIndex, UInt1Vector from) {
        this.data.setByte(thisIndex * 1, from.data.getByte(fromIndex * 1));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, UInt1Vector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        ((UInt1Vector)from).data.getBytes(fromIndex * 1, this.data, toIndex * 1, 1);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public static final class BufferedMutator {
        private static final int DEFAULT_BUFF_SZ = 4096;
        private final ByteBuffer buffer;
        private int currentIdx;
        private final UInt1Vector parent;

        public BufferedMutator(int _start_idx, UInt1Vector _parent) {
            this(_start_idx, 4096, _parent);
        }

        public BufferedMutator(int start_idx, int _buff_sz, UInt1Vector parent) {
            this.buffer = ByteBuffer.allocate(_buff_sz);
            this.buffer.order(ByteOrder.nativeOrder());
            this.currentIdx = start_idx;
            this.parent = parent;
        }

        public void setSafe(byte value) {
            if (this.buffer.remaining() < 1) {
                this.flush();
            }
            this.buffer.put(value);
        }

        public void setSafe(byte[] values, int numValues) {
            int toCopy;
            int remaining = numValues;
            byte[] buffer_array = this.buffer.array();
            int src_pos = 0;
            do {
                if (this.buffer.remaining() < 1) {
                    this.flush();
                }
                toCopy = Math.min(remaining, this.buffer.remaining());
                int tgt_pos = this.buffer.position();
                for (int idx = 0; idx < toCopy; ++idx) {
                    buffer_array[tgt_pos++] = values[src_pos++];
                }
                this.buffer.position(tgt_pos);
            } while ((remaining -= toCopy) > 0);
        }

        public ByteBuffer getByteBuffer() {
            return this.buffer;
        }

        public void flush() {
            int numElements = this.buffer.position() / 1;
            if (numElements == 0) {
                return;
            }
            while (this.currentIdx + numElements - 1 >= this.parent.getValueCapacity()) {
                this.parent.reAlloc();
            }
            this.parent.data.setBytes(this.currentIdx * 1, this.buffer.array(), 0, this.buffer.position());
            this.currentIdx += numElements;
            this.buffer.clear();
        }
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            UInt1Vector.this.data.setByte(index * 1, value);
        }

        public void set(int index, byte[] values, int startOff, int len) {
            UInt1Vector.this.data.setBytes(index * 1, values, startOff, len);
        }

        public void setSafe(int index, int value) {
            while (index >= UInt1Vector.this.getValueCapacity()) {
                UInt1Vector.this.reAlloc();
            }
            this.set(index, value);
        }

        public void setScalar(int index, int value) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, value);
        }

        public void setArrayItem(int index, int value) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, value);
        }

        protected void set(int index, UInt1Holder holder) {
            UInt1Vector.this.data.setByte(index * 1, holder.value);
        }

        public void setSafe(int index, UInt1Holder holder) {
            while (index >= UInt1Vector.this.getValueCapacity()) {
                UInt1Vector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void setScalar(int index, UInt1Holder holder) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        public void setArrayItem(int index, UInt1Holder holder) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        protected void set(int index, NullableUInt1Holder holder) {
            UInt1Vector.this.data.setByte(index * 1, holder.value);
        }

        public void setSafe(int index, NullableUInt1Holder holder) {
            while (index >= UInt1Vector.this.getValueCapacity()) {
                UInt1Vector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void setScalar(int index, NullableUInt1Holder holder) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        public void setArrayItem(int index, NullableUInt1Holder holder) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = UInt1Vector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, -128);
                } else {
                    this.set(i, 127);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = UInt1Vector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            for (int i = lastWrite + 1; i <= index; ++i) {
                this.setSafe(i, 0);
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = UInt1Vector.this.getValueCapacity();
            int idx = 1 * valueCount;
            while (valueCount > UInt1Vector.this.getValueCapacity()) {
                UInt1Vector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                UInt1Vector.this.incrementAllocationMonitor();
            } else if (UInt1Vector.this.allocationMonitor > 0) {
                UInt1Vector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(UInt1Vector.this.data, idx);
            UInt1Vector.this.data.writerIndex(valueCount * 1);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return UInt1Vector.this.data.writerIndex() / 1;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public byte get(int index) {
            return UInt1Vector.this.data.getByte(index * 1);
        }

        @Override
        public Byte getObject(int index) {
            return this.get(index);
        }

        public byte getPrimitiveObject(int index) {
            return this.get(index);
        }

        public void get(int index, UInt1Holder holder) {
            holder.value = UInt1Vector.this.data.getByte(index * 1);
        }

        public void get(int index, NullableUInt1Holder holder) {
            holder.isSet = 1;
            holder.value = UInt1Vector.this.data.getByte(index * 1);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private UInt1Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new UInt1Vector(field, allocator);
        }

        public TransferImpl(UInt1Vector to) {
            this.to = to;
        }

        @Override
        public UInt1Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UInt1Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            UInt1Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, UInt1Vector.this);
        }
    }
}

