/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.TimeReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.DateTime;
import oadd.org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(TimeVector.class);
    public static final int VALUE_WIDTH = 4;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 4;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 4 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new TimeReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(16384, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public TimeVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 4;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 4;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 4);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        long l = newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0L) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 4;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TimeVector)to);
    }

    public void transferTo(TimeVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, TimeVector target) {
        int startPoint = startIndex * 4;
        int sliceLength = length * 4;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 4;
    }

    public void copyFrom(int fromIndex, int thisIndex, TimeVector from) {
        this.data.setInt(thisIndex * 4, from.data.getInt(fromIndex * 4));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TimeVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        ((TimeVector)from).data.getBytes(fromIndex * 4, this.data, toIndex * 4, 4);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            TimeVector.this.data.setInt(index * 4, value);
        }

        public void setSafe(int index, int value) {
            while (index >= TimeVector.this.getValueCapacity()) {
                TimeVector.this.reAlloc();
            }
            this.set(index, value);
        }

        public void setScalar(int index, int value) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, value);
        }

        public void setArrayItem(int index, int value) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, value);
        }

        protected void set(int index, TimeHolder holder) {
            TimeVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, TimeHolder holder) {
            while (index >= TimeVector.this.getValueCapacity()) {
                TimeVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void setScalar(int index, TimeHolder holder) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        public void setArrayItem(int index, TimeHolder holder) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        protected void set(int index, NullableTimeHolder holder) {
            TimeVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, NullableTimeHolder holder) {
            while (index >= TimeVector.this.getValueCapacity()) {
                TimeVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void setScalar(int index, NullableTimeHolder holder) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        public void setArrayItem(int index, NullableTimeHolder holder) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = TimeVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Integer.MIN_VALUE);
                } else {
                    this.set(i, Integer.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = TimeVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            for (int i = lastWrite + 1; i <= index; ++i) {
                this.setSafe(i, 0);
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = TimeVector.this.getValueCapacity();
            int idx = 4 * valueCount;
            while (valueCount > TimeVector.this.getValueCapacity()) {
                TimeVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                TimeVector.this.incrementAllocationMonitor();
            } else if (TimeVector.this.allocationMonitor > 0) {
                TimeVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(TimeVector.this.data, idx);
            TimeVector.this.data.writerIndex(valueCount * 4);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return TimeVector.this.data.writerIndex() / 4;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int get(int index) {
            return TimeVector.this.data.getInt(index * 4);
        }

        public long getTwoAsLong(int index) {
            return TimeVector.this.data.getLong(index * 4);
        }

        @Override
        public DateTime getObject(int index) {
            DateTime time = new DateTime((long)this.get(index), DateTimeZone.UTC);
            time = time.withZoneRetainFields(DateTimeZone.getDefault());
            return time;
        }

        public void get(int index, TimeHolder holder) {
            holder.value = TimeVector.this.data.getInt(index * 4);
        }

        public void get(int index, NullableTimeHolder holder) {
            holder.isSet = 1;
            holder.value = TimeVector.this.data.getInt(index * 4);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private TimeVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new TimeVector(field, allocator);
        }

        public TransferImpl(TimeVector to) {
            this.to = to;
        }

        @Override
        public TimeVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TimeVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TimeVector.this);
        }
    }
}

