/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.Var16CharHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.Var16CharVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedVar16CharReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedVar16CharVector
extends BaseRepeatedValueVector
implements RepeatedVariableWidthVectorLike {
    private Var16CharVector values;
    private final FieldReader reader = new RepeatedVar16CharReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVar16CharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Var16CharVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedVar16CharVector)to);
    }

    public AddOrGetResult<Var16CharVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<Var16CharVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedVar16CharVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedVar16CharVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedVar16CharVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedVar16CharVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedVar16CharVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().setVarByteLength(this.values.getVarByteLength());
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount, int innerValueCount) {
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(totalBytes, innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedVar16CharVector.this);
        }

        public void add(int index, byte[] value) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().set(nextOffset, value);
            RepeatedVar16CharVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte[] bytes) {
            this.addSafe(index, bytes, 0, bytes.length);
        }

        public void addEntry(int index, byte[] bytes) throws VectorOverflowException {
            this.addEntry(index, bytes, 0, bytes.length);
        }

        public void addSafe(int index, byte[] bytes, int start, int length) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, bytes, start, length);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, byte[] bytes, int start, int length) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setArrayItem(nextOffset, bytes, start, length);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedVar16CharHolder h) {
            Var16CharHolder ih = new Var16CharHolder();
            Var16CharVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedVar16CharVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedVar16CharVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Var16CharHolder holder) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, Var16CharHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableVar16CharHolder holder) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, NullableVar16CharHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedVar16CharVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        public void addSafe(int rowIndex, int start, int end, DrillBuf buffer) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, start, end, buffer);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        public void addEntry(int rowIndex, int start, int end, DrillBuf buffer) throws VectorOverflowException {
            if (rowIndex >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedVar16CharVector.this.values.getMutator().setArrayItem(nextOffset, start, end, buffer);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        protected void add(int index, Var16CharHolder holder) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedVar16CharHolder holder) {
            Var16CharVector.Accessor accessor = holder.vector.getAccessor();
            Var16CharHolder innerHolder = new Var16CharHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedVar16CharVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedVar16CharVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedVar16CharVector.this);
        }

        @Override
        public List<String> getObject(int index) {
            JsonStringArrayList<String> vals = new JsonStringArrayList<String>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedVar16CharVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Var16CharVector.Accessor valuesAccessor = RepeatedVar16CharVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public String getSingleObject(int index, int arrayIndex) {
            int start = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            return RepeatedVar16CharVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte[] get(int index, int positionIndex) {
            return RepeatedVar16CharVector.this.values.getAccessor().get(RepeatedVar16CharVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedVar16CharHolder holder) {
            holder.start = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedVar16CharVector.this.values;
        }

        public void get(int index, int positionIndex, Var16CharHolder holder) {
            int offset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedVar16CharVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableVar16CharHolder holder) {
            int offset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedVar16CharVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedVar16CharVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedVar16CharVector(field, allocator);
        }

        public TransferImpl(RepeatedVar16CharVector to) {
            this.to = to;
        }

        @Override
        public RepeatedVar16CharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedVar16CharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedVar16CharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedVar16CharVector.this);
        }
    }
}

