/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.IntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntervalDayHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.IntervalDayVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedIntervalDayReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;

public final class RepeatedIntervalDayVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private IntervalDayVector values;
    private final FieldReader reader = new RepeatedIntervalDayReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedIntervalDayVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public IntervalDayVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedIntervalDayVector)to);
    }

    public AddOrGetResult<IntervalDayVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<IntervalDayVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedIntervalDayVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedIntervalDayVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedIntervalDayVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedIntervalDayVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedIntervalDayVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, DrillBuf value) {
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().set(nextOffset, value);
            RepeatedIntervalDayVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, DrillBuf srcValue) {
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, DrillBuf srcValue) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setArrayItem(nextOffset, srcValue);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedIntervalDayHolder h) {
            IntervalDayHolder ih = new IntervalDayHolder();
            IntervalDayVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedIntervalDayVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedIntervalDayVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, IntervalDayHolder holder) {
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, IntervalDayHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableIntervalDayHolder holder) {
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, NullableIntervalDayHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedIntervalDayVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        public void addSafe(int rowIndex, int days, int milliseconds) {
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setSafe(nextOffset, days, milliseconds);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        public void addEntry(int rowIndex, int days, int milliseconds) throws VectorOverflowException {
            if (rowIndex >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedIntervalDayVector.this.values.getMutator().setArrayItem(nextOffset, days, milliseconds);
            RepeatedIntervalDayVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        protected void add(int index, IntervalDayHolder holder) {
            int nextOffset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalDayVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedIntervalDayVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedIntervalDayHolder holder) {
            IntervalDayVector.Accessor accessor = holder.vector.getAccessor();
            IntervalDayHolder innerHolder = new IntervalDayHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedIntervalDayVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedIntervalDayVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<Period> getObject(int index) {
            JsonStringArrayList<Period> vals = new JsonStringArrayList<Period>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedIntervalDayVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            IntervalDayVector.Accessor valuesAccessor = RepeatedIntervalDayVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Period getSingleObject(int index, int arrayIndex) {
            int start = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index);
            return RepeatedIntervalDayVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public DrillBuf get(int index, int positionIndex) {
            return RepeatedIntervalDayVector.this.values.getAccessor().get(RepeatedIntervalDayVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedIntervalDayHolder holder) {
            holder.start = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedIntervalDayVector.this.values;
        }

        public void get(int index, int positionIndex, IntervalDayHolder holder) {
            int offset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedIntervalDayVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableIntervalDayHolder holder) {
            int offset = RepeatedIntervalDayVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedIntervalDayVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedIntervalDayVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedIntervalDayVector(field, allocator);
        }

        public TransferImpl(RepeatedIntervalDayVector to) {
            this.to = to;
        }

        @Override
        public RepeatedIntervalDayVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedIntervalDayVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedIntervalDayVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedIntervalDayVector.this);
        }
    }
}

