/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.IntVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedIntReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedIntVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private IntVector values;
    private final FieldReader reader = new RepeatedIntReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedIntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public IntVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedIntVector)to);
    }

    public AddOrGetResult<IntVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<IntVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedIntVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedIntVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedIntVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedIntVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedIntVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedIntVector.this);
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().set(nextOffset, value);
            RepeatedIntVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, int srcValue) {
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, int srcValue) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().setArrayItem(nextOffset, srcValue);
            RepeatedIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedIntHolder h) {
            IntHolder ih = new IntHolder();
            IntVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedIntVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedIntVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, IntHolder holder) {
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, IntHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableIntHolder holder) {
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, NullableIntHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = RepeatedIntVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedIntVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, IntHolder holder) {
            int nextOffset = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedIntVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedIntHolder holder) {
            IntVector.Accessor accessor = holder.vector.getAccessor();
            IntHolder innerHolder = new IntHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedIntVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedIntVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedIntVector.this);
        }

        @Override
        public List<Integer> getObject(int index) {
            JsonStringArrayList<Integer> vals = new JsonStringArrayList<Integer>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedIntVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            IntVector.Accessor valuesAccessor = RepeatedIntVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Integer getSingleObject(int index, int arrayIndex) {
            int start = RepeatedIntVector.this.offsets.getAccessor().get(index);
            return RepeatedIntVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public int get(int index, int positionIndex) {
            return RepeatedIntVector.this.values.getAccessor().get(RepeatedIntVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedIntHolder holder) {
            holder.start = RepeatedIntVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedIntVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedIntVector.this.values;
        }

        public void get(int index, int positionIndex, IntHolder holder) {
            int offset = RepeatedIntVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedIntVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableIntHolder holder) {
            int offset = RepeatedIntVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedIntVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedIntVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedIntVector(field, allocator);
        }

        public TransferImpl(RepeatedIntVector to) {
            this.to = to;
        }

        @Override
        public RepeatedIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedIntVector.this);
        }
    }
}

