/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDecimal28DenseHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.Decimal28DenseVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDecimal28DenseReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedDecimal28DenseVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private Decimal28DenseVector values;
    private final FieldReader reader = new RepeatedDecimal28DenseReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedDecimal28DenseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Decimal28DenseVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedDecimal28DenseVector)to);
    }

    public AddOrGetResult<Decimal28DenseVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<Decimal28DenseVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedDecimal28DenseVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedDecimal28DenseVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedDecimal28DenseVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedDecimal28DenseVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedDecimal28DenseVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, DrillBuf value) {
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().set(nextOffset, value);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, DrillBuf srcValue) {
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, DrillBuf srcValue) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().setArrayItem(nextOffset, srcValue);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedDecimal28DenseHolder h) {
            Decimal28DenseHolder ih = new Decimal28DenseHolder();
            Decimal28DenseVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedDecimal28DenseVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedDecimal28DenseVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Decimal28DenseHolder holder) {
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, Decimal28DenseHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableDecimal28DenseHolder holder) {
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, NullableDecimal28DenseHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedDecimal28DenseVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, Decimal28DenseHolder holder) {
            int nextOffset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal28DenseVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedDecimal28DenseVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedDecimal28DenseHolder holder) {
            Decimal28DenseVector.Accessor accessor = holder.vector.getAccessor();
            Decimal28DenseHolder innerHolder = new Decimal28DenseHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedDecimal28DenseVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedDecimal28DenseVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList<BigDecimal> vals = new JsonStringArrayList<BigDecimal>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedDecimal28DenseVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Decimal28DenseVector.Accessor valuesAccessor = RepeatedDecimal28DenseVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public BigDecimal getSingleObject(int index, int arrayIndex) {
            int start = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index);
            return RepeatedDecimal28DenseVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public DrillBuf get(int index, int positionIndex) {
            return RepeatedDecimal28DenseVector.this.values.getAccessor().get(RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedDecimal28DenseHolder holder) {
            holder.start = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedDecimal28DenseVector.this.values;
        }

        public void get(int index, int positionIndex, Decimal28DenseHolder holder) {
            int offset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedDecimal28DenseVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableDecimal28DenseHolder holder) {
            int offset = RepeatedDecimal28DenseVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedDecimal28DenseVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedDecimal28DenseVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedDecimal28DenseVector(field, allocator);
        }

        public TransferImpl(RepeatedDecimal28DenseVector to) {
            this.to = to;
        }

        @Override
        public RepeatedDecimal28DenseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedDecimal28DenseVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedDecimal28DenseVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedDecimal28DenseVector.this);
        }
    }
}

