/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.Text;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.VLBulkEntry;
import oadd.org.apache.drill.exec.vector.VLBulkInput;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VarCharVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableVarCharReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableVarCharVector
extends BaseDataValueVector
implements VariableWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableVarCharVector.class);
    private static final int DEFINED_VALUES_ARRAY_LEN = 1024;
    private static final byte[] DEFINED_VALUES_ARRAY = new byte[1024];
    private final FieldReader reader = new NullableVarCharReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create("$bits$", Types.required(TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final VarCharVector values = new VarCharVector(this.field, this.allocator);
    private final Mutator mutator = new MutatorImpl();
    private final Accessor accessor = new AccessorImpl();
    private final Mutator dupMutator = new DupValsOnlyMutator();
    private final Accessor dupAccessor = new DupValsOnlyAccessor();
    private final Accessor delegateAccessor = new DelegateAccessor();
    private boolean duplicateValuesOnly;
    private int logicalNumValues;
    private int logicalValueCapacity;

    public boolean isDuplicateValsOnly() {
        return this.duplicateValuesOnly;
    }

    public Accessor getDelegateAccessor() {
        return this.delegateAccessor;
    }

    public void setDuplicateValsOnly(boolean valsOnly) {
        this.clear();
        this.duplicateValuesOnly = valsOnly;
    }

    @Override
    public int getValueCapacity() {
        if (!this.isDuplicateValsOnly()) {
            return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
        }
        return this.logicalValueCapacity;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
        if (this.isDuplicateValsOnly()) {
            this.logicalNumValues = 0;
            this.logicalValueCapacity = 0;
            this.duplicateValuesOnly = false;
        }
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        assert (valueCount >= 0);
        if (valueCount == 0) {
            return 0;
        }
        if (!this.isDuplicateValsOnly()) {
            return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
        }
        return this.values.getBufferSizeFor(1) + this.bits.getBufferSizeFor(1);
    }

    @Override
    public VarCharVector getValuesVector() {
        return this.values;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        assert (numRecords >= 0);
        if (!this.isDuplicateValsOnly()) {
            this.bits.setInitialCapacity(numRecords);
            this.values.setInitialCapacity(numRecords);
        } else {
            this.bits.setInitialCapacity(numRecords > 0 ? 1 : 0);
            this.values.setInitialCapacity(numRecords > 0 ? 1 : 0);
            this.logicalValueCapacity = numRecords;
        }
    }

    @Override
    public Accessor getAccessor() {
        if (!this.isDuplicateValsOnly()) {
            return this.accessor;
        }
        return this.dupAccessor;
    }

    @Override
    public Mutator getMutator() {
        if (!this.isDuplicateValsOnly()) {
            return this.mutator;
        }
        return this.dupMutator;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableVarCharVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (this.isDuplicateValsOnly()) {
            assert (this.isDuplicateValsOnly() == from.isDuplicateValsOnly());
            if (this.logicalNumValues == from.logicalNumValues) {
                return;
            }
            this.getMutator().setValueCount(from.logicalNumValues);
            this.setInitialCapacity(from.logicalValueCapacity);
        }
        if (!fromAccessor.isNull(fromIndex)) {
            fromIndex = !from.isDuplicateValsOnly() ? fromIndex : 0;
            this.mutator.fillEmpties(thisIndex);
            this.bits.copyFrom(fromIndex, thisIndex, from.bits);
            this.values.copyFrom(fromIndex, thisIndex, from.values);
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, VarCharVector from) {
        assert (!this.isDuplicateValsOnly());
        this.mutator.fillEmpties(thisIndex);
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableVarCharVector from) {
        if (this.isDuplicateValsOnly()) {
            assert (this.isDuplicateValsOnly() == from.isDuplicateValsOnly());
            if (this.logicalNumValues == from.logicalNumValues) {
                return;
            }
            this.getMutator().setValueCount(from.logicalNumValues);
            this.setInitialCapacity(from.logicalValueCapacity);
        }
        fromIndex = !from.isDuplicateValsOnly() ? fromIndex : 0;
        this.mutator.fillEmpties(thisIndex);
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        if (this.isDuplicateValsOnly()) {
            throw new UnsupportedOperationException();
        }
        NullableVarCharVector fromVector = (NullableVarCharVector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        if (this.isDuplicateValsOnly()) {
            throw new UnsupportedOperationException();
        }
        NullableVarCharVector target = (NullableVarCharVector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        if (!this.isDuplicateValsOnly()) {
            return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
        }
        return super.getMetadataBuilder().setIsDup(true).setLogicalValueCount(this.logicalNumValues).addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        this.duplicateValuesOnly = metadata.getIsDup();
        this.logicalNumValues = metadata.getLogicalValueCount();
        this.logicalValueCapacity = metadata.getLogicalValueCount();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        if (this.isDuplicateValsOnly()) {
            valueCount = valueCount > 0 ? 1 : 0;
        }
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    private final void undoOptimization() {
        this.duplicateValuesOnly = false;
        Mutator mutator = this.getMutator();
        if (this.logicalNumValues > 0 && this.logicalValueCapacity > 0) {
            this.setInitialCapacity(this.logicalValueCapacity);
            if (!this.getAccessor().isNull(0)) {
                byte[] value = this.getAccessor().get(0);
                for (int idx = 1; idx < this.logicalNumValues; ++idx) {
                    mutator.setSafe(idx, value, 0, value.length);
                }
            }
            mutator.setValueCount(this.logicalNumValues);
        }
    }

    public NullableVarCharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        try {
            this.values.allocateNew(totalBytes, valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (RuntimeException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return this.values.getCurrentSizeInBytes();
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableVarCharVector)to);
    }

    public void transferTo(NullableVarCharVector target) {
        if (this.isDuplicateValsOnly() && this.logicalNumValues > 0) {
            if (!target.isDuplicateValsOnly()) {
                target.setDuplicateValsOnly(true);
            }
            target.logicalNumValues = this.logicalNumValues;
            target.logicalValueCapacity = this.logicalValueCapacity;
        }
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.mutator.lastSet = this.mutator.lastSet;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableVarCharVector target) {
        if (this.isDuplicateValsOnly()) {
            if (!target.isDuplicateValsOnly() || startIndex > 0) {
                throw new UnsupportedOperationException();
            }
            target.logicalNumValues = this.logicalNumValues;
            target.logicalValueCapacity = this.logicalValueCapacity;
            startIndex = 0;
            length = 1;
        }
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
        target.mutator.lastSet = length - 1;
    }

    public VarCharVector convertToRequiredVector() {
        VarCharVector v = new VarCharVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    static {
        Arrays.fill(DEFINED_VALUES_ARRAY, (byte)1);
    }

    public final class DupValsOnlyMutator
    extends Mutator {
        private DupValsOnlyMutator() {
        }

        @Override
        public VarCharVector getVectorWithValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIndexDefined(int index) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().set(0, 1);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setIndexDefined(index);
            }
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            if (index == 0) {
                this.setIndexDefined(index);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setIndexDefined(index, numValues);
            }
        }

        @Override
        public void set(int index, byte[] value) {
            if (index == 0) {
                this.setCount = 1;
                VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
                UInt1Vector.Mutator bitsMutator = NullableVarCharVector.this.bits.getMutator();
                bitsMutator.set(0, 1);
                valuesMutator.set(0, value);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().set(index, value);
            }
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            if (index == 0) {
                NullableVarCharVector.this.values.getMutator().setValueLengthSafe(0, length);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setValueLengthSafe(index, length);
            }
        }

        @Override
        public void setSafe(int index, byte[] value, int start, int length) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 1);
                NullableVarCharVector.this.values.getMutator().setSafe(0, value, start, length);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSafe(index, value, start, length);
            }
        }

        @Override
        public void setScalar(int index, byte[] value, int start, int length) throws VectorOverflowException {
            if (index == 0) {
                NullableVarCharVector.this.values.getMutator().setScalar(0, value, start, length);
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 1);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setScalar(index, value, start, length);
            }
        }

        @Override
        public void setSafe(int index, ByteBuffer value, int start, int length) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 1);
                NullableVarCharVector.this.values.getMutator().setSafe(0, value, start, length);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSafe(index, value, start, length);
            }
        }

        @Override
        public void setScalar(int index, DrillBuf value, int start, int length) throws VectorOverflowException {
            if (index == 0) {
                NullableVarCharVector.this.values.getMutator().setScalar(0, value, start, length);
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 1);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setScalar(index, value, start, length);
            }
        }

        @Override
        public void setNull(int index) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 0);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setNull(index);
            }
        }

        @Override
        public void setSkipNull(int index, VarCharHolder holder) {
            if (index == 0) {
                NullableVarCharVector.this.values.getMutator().set(0, holder);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSkipNull(index, holder);
            }
        }

        @Override
        public void setSkipNull(int index, NullableVarCharHolder holder) {
            if (index == 0) {
                NullableVarCharVector.this.values.getMutator().set(0, holder);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSkipNull(index, holder);
            }
        }

        @Override
        public void setNullBounded(int index) throws VectorOverflowException {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setScalar(0, 0);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setNullBounded(index);
            }
        }

        @Override
        public void set(int index, NullableVarCharHolder holder) {
            if (index == 0) {
                VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
                NullableVarCharVector.this.bits.getMutator().set(0, holder.isSet);
                valuesMutator.set(0, holder);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().set(index, holder);
            }
        }

        @Override
        public void set(int index, VarCharHolder holder) {
            if (index == 0) {
                VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
                NullableVarCharVector.this.bits.getMutator().set(0, 1);
                valuesMutator.set(0, holder);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().set(index, holder);
            }
        }

        @Override
        public boolean isSafe(int outIndex) {
            NullableVarCharVector.this.undoOptimization();
            return NullableVarCharVector.this.getMutator().isSafe(outIndex);
        }

        @Override
        public void set(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().set(0, isSet);
                NullableVarCharVector.this.values.getMutator().set(0, startField, endField, bufferField);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().set(index, isSet, startField, endField, bufferField);
            }
        }

        @Override
        public void setSafe(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, isSet);
                NullableVarCharVector.this.values.getMutator().setSafe(0, startField, endField, bufferField);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSafe(index, isSet, startField, endField, bufferField);
            }
        }

        @Override
        public void setScalar(int index, int isSet, int startField, int endField, DrillBuf bufferField) throws VectorOverflowException {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, isSet);
                NullableVarCharVector.this.values.getMutator().setScalar(0, startField, endField, bufferField);
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setScalar(index, isSet, startField, endField, bufferField);
            }
        }

        @Override
        public void setSafe(int index, NullableVarCharHolder value) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, value.isSet);
                NullableVarCharVector.this.values.getMutator().setSafe(0, value);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSafe(index, value);
            }
        }

        @Override
        public void setScalar(int index, NullableVarCharHolder value) throws VectorOverflowException {
            if (index == 0) {
                NullableVarCharVector.this.values.getMutator().setScalar(0, value);
                NullableVarCharVector.this.bits.getMutator().setSafe(0, value.isSet);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setScalar(index, value);
            }
        }

        @Override
        public void setSafe(int index, VarCharHolder value) {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 1);
                NullableVarCharVector.this.values.getMutator().setSafe(0, value);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setSafe(index, value);
            }
        }

        @Override
        public void setScalar(int index, VarCharHolder value) throws VectorOverflowException {
            if (index == 0) {
                NullableVarCharVector.this.bits.getMutator().setSafe(0, 1);
                this.setCount = 1;
            } else {
                NullableVarCharVector.this.undoOptimization();
                NullableVarCharVector.this.getMutator().setScalar(index, value);
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableVarCharVector.this.logicalNumValues = valueCount;
            NullableVarCharVector.this.logicalValueCapacity = valueCount;
            NullableVarCharVector.this.values.getMutator().setValueCount(valueCount > 0 ? 1 : 0);
            NullableVarCharVector.this.bits.getMutator().setValueCount(valueCount > 0 ? 1 : 0);
        }

        @Override
        public void setSafe(VLBulkInput<VLBulkEntry> input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void generateTestData(int valueCount) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.setCount = 0;
            NullableVarCharVector.this.logicalNumValues = 0;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void fillEmpties(int index) {
        }
    }

    public final class MutatorImpl
    extends Mutator {
        private MutatorImpl() {
        }

        @Override
        public VarCharVector getVectorWithValues() {
            return NullableVarCharVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableVarCharVector.this.bits.getMutator().set(index, 1);
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            int batchSz;
            for (int remaining = numValues; remaining > 0; remaining -= batchSz) {
                batchSz = Math.min(remaining, 1024);
                NullableVarCharVector.this.bits.getMutator().set(index + (numValues - remaining), DEFINED_VALUES_ARRAY, 0, batchSz);
            }
        }

        @Override
        public void set(int index, byte[] value) {
            ++this.setCount;
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableVarCharVector.this.bits.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
            this.lastSet = index;
        }

        @Override
        protected void fillEmpties(int index) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            for (int i = this.lastSet; i < index; ++i) {
                valuesMutator.setSafe(i + 1, BaseDataValueVector.emptyByteArray);
            }
            while (index > NullableVarCharVector.this.bits.getValueCapacity()) {
                NullableVarCharVector.this.bits.reAlloc();
            }
            this.lastSet = index;
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            NullableVarCharVector.this.values.getMutator().setValueLengthSafe(index, length);
            this.lastSet = index;
        }

        @Override
        public void setSafe(int index, byte[] value, int start, int length) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value, start, length);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setScalar(int index, byte[] value, int start, int length) throws VectorOverflowException {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.values.getMutator().setScalar(index, value, start, length);
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setSafe(int index, ByteBuffer value, int start, int length) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value, start, length);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setScalar(int index, DrillBuf value, int start, int length) throws VectorOverflowException {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.values.getMutator().setScalar(index, value, start, length);
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setNull(int index) {
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 0);
        }

        @Override
        public void setSkipNull(int index, VarCharHolder holder) {
            NullableVarCharVector.this.values.getMutator().set(index, holder);
        }

        @Override
        public void setSkipNull(int index, NullableVarCharHolder holder) {
            NullableVarCharVector.this.values.getMutator().set(index, holder);
        }

        @Override
        public void setNullBounded(int index) throws VectorOverflowException {
            NullableVarCharVector.this.bits.getMutator().setScalar(index, 0);
        }

        @Override
        public void set(int index, NullableVarCharHolder holder) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVarCharVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        @Override
        public void set(int index, VarCharHolder holder) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVarCharVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        @Override
        public boolean isSafe(int outIndex) {
            return outIndex < NullableVarCharVector.this.getValueCapacity();
        }

        @Override
        public void set(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            VarCharVector.Mutator valuesMutator = NullableVarCharVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVarCharVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, startField, endField, bufferField);
            this.lastSet = index;
        }

        @Override
        public void setSafe(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, isSet);
            NullableVarCharVector.this.values.getMutator().setSafe(index, startField, endField, bufferField);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setScalar(int index, int isSet, int startField, int endField, DrillBuf bufferField) throws VectorOverflowException {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.values.getMutator().setScalar(index, startField, endField, bufferField);
            NullableVarCharVector.this.bits.getMutator().setSafe(index, isSet);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setSafe(int index, NullableVarCharHolder value) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setScalar(int index, NullableVarCharHolder value) throws VectorOverflowException {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.values.getMutator().setScalar(index, value);
            NullableVarCharVector.this.bits.getMutator().setSafe(index, value.isSet);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setSafe(int index, VarCharHolder value) {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarCharVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setScalar(int index, VarCharHolder value) throws VectorOverflowException {
            if (index > this.lastSet + 1) {
                this.fillEmpties(index);
            }
            NullableVarCharVector.this.values.getMutator().setScalar(index, value);
            NullableVarCharVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            this.fillEmpties(valueCount);
            NullableVarCharVector.this.values.getMutator().setValueCount(valueCount);
            NullableVarCharVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void setSafe(VLBulkInput<VLBulkEntry> input) {
            VLBulkInputCallbackImpl callback = new VLBulkInputCallbackImpl(input.getStartIndex());
            NullableVarCharVector.this.values.getMutator().setSafe(input, callback);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableVarCharVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableVarCharVector.this.values.getMutator().generateTestData(valueCount);
            this.lastSet = valueCount;
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.setCount = 0;
            this.lastSet = -1;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
            Mutator target = (Mutator)other;
            int temp = this.setCount;
            this.setCount = target.setCount;
            target.setCount = temp;
        }

        private final class VLBulkInputCallbackImpl
        implements VLBulkInput.BulkInputCallback<VLBulkEntry> {
            private static final int DEFAULT_BUFF_SZ = 4096;
            private final UInt1Vector.BufferedMutator bitsMutator;

            private VLBulkInputCallbackImpl(int _start_idx) {
                this.bitsMutator = new UInt1Vector.BufferedMutator(_start_idx, 4096, NullableVarCharVector.this.bits);
            }

            @Override
            public void onNewBulkEntry(VLBulkEntry entry) {
                int toCopy;
                int[] lengths = entry.getValuesLength();
                ByteBuffer buffer = this.bitsMutator.getByteBuffer();
                byte[] buffer_array = buffer.array();
                int remaining = entry.getNumValues();
                int srcPos = 0;
                do {
                    int idx;
                    if (buffer.remaining() < 1) {
                        this.bitsMutator.flush();
                    }
                    toCopy = Math.min(remaining, buffer.remaining());
                    int startTgtPos = buffer.position();
                    int maxTgtPos = startTgtPos + toCopy;
                    if (entry.hasNulls()) {
                        for (idx = startTgtPos; idx < maxTgtPos; ++idx) {
                            int valLen;
                            if ((valLen = lengths[srcPos++]) >= 0) {
                                buffer_array[idx] = 1;
                                ++MutatorImpl.this.setCount;
                                continue;
                            }
                            buffer_array[idx] = 0;
                        }
                    } else {
                        for (idx = startTgtPos; idx < maxTgtPos; ++idx) {
                            buffer_array[idx] = 1;
                        }
                        MutatorImpl.this.setCount += toCopy;
                    }
                    buffer.position(maxTgtPos);
                } while ((remaining -= toCopy) > 0);
                MutatorImpl.this.lastSet += entry.getNumValues();
            }

            @Override
            public void onEndBulkInput() {
                this.bitsMutator.flush();
            }
        }
    }

    public abstract class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter,
    VariableWidthVector.VariableWidthMutator {
        protected int setCount;
        protected int lastSet = -1;

        private Mutator() {
        }

        public abstract VarCharVector getVectorWithValues();

        public abstract void set(int var1, byte[] var2);

        public abstract void setSafe(int var1, byte[] var2, int var3, int var4);

        public abstract void setScalar(int var1, byte[] var2, int var3, int var4) throws VectorOverflowException;

        public abstract void setSafe(int var1, ByteBuffer var2, int var3, int var4);

        public abstract void setScalar(int var1, DrillBuf var2, int var3, int var4) throws VectorOverflowException;

        protected abstract void fillEmpties(int var1);

        public abstract void setNull(int var1);

        public abstract void setSkipNull(int var1, VarCharHolder var2);

        public abstract void setSkipNull(int var1, NullableVarCharHolder var2);

        public abstract void setNullBounded(int var1) throws VectorOverflowException;

        public abstract void set(int var1, NullableVarCharHolder var2);

        public abstract void set(int var1, VarCharHolder var2);

        public abstract boolean isSafe(int var1);

        public abstract void set(int var1, int var2, int var3, int var4, DrillBuf var5);

        public abstract void setSafe(int var1, int var2, int var3, int var4, DrillBuf var5);

        public abstract void setScalar(int var1, int var2, int var3, int var4, DrillBuf var5) throws VectorOverflowException;

        public abstract void setSafe(int var1, NullableVarCharHolder var2);

        public abstract void setScalar(int var1, NullableVarCharHolder var2) throws VectorOverflowException;

        public abstract void setSafe(int var1, VarCharHolder var2);

        public abstract void setScalar(int var1, VarCharHolder var2) throws VectorOverflowException;

        public abstract void setSafe(VLBulkInput<VLBulkEntry> var1);
    }

    public final class DelegateAccessor
    extends Accessor {
        @Override
        public byte[] get(int index) {
            return this.getCurrentAccessor().get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.getCurrentAccessor().isNull(index);
        }

        @Override
        public int isSet(int index) {
            return this.getCurrentAccessor().isSet(index);
        }

        @Override
        public long getStartEnd(int index) {
            return this.getCurrentAccessor().getStartEnd(index);
        }

        @Override
        public int getValueLength(int index) {
            return this.getCurrentAccessor().getValueLength(index);
        }

        @Override
        public void get(int index, NullableVarCharHolder holder) {
            this.getCurrentAccessor().get(index, holder);
        }

        @Override
        public Text getObject(int index) {
            return this.getCurrentAccessor().getObject(index);
        }

        @Override
        public int getValueCount() {
            return this.getCurrentAccessor().getValueCount();
        }

        private Accessor getCurrentAccessor() {
            if (!NullableVarCharVector.this.isDuplicateValsOnly()) {
                return NullableVarCharVector.this.accessor;
            }
            return NullableVarCharVector.this.dupAccessor;
        }
    }

    public final class DupValsOnlyAccessor
    extends Accessor {
        @Override
        public byte[] get(int index) {
            this.chkIndex(index);
            if (this.isNull(0)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(0);
        }

        @Override
        public boolean isNull(int index) {
            this.chkIndex(index);
            return this.bAccessor.get(0) == 0;
        }

        @Override
        public int isSet(int index) {
            this.chkIndex(index);
            return this.bAccessor.get(0);
        }

        @Override
        public long getStartEnd(int index) {
            this.chkIndex(index);
            return this.vAccessor.getStartEnd(0);
        }

        @Override
        public int getValueLength(int index) {
            this.chkIndex(index);
            return NullableVarCharVector.this.values.getAccessor().getValueLength(0);
        }

        @Override
        public void get(int index, NullableVarCharHolder holder) {
            this.chkIndex(index);
            this.vAccessor.get(0, holder);
            holder.isSet = this.bAccessor.get(0);
        }

        @Override
        public Text getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(0);
        }

        @Override
        public int getValueCount() {
            return NullableVarCharVector.this.logicalNumValues;
        }

        private void chkIndex(int index) {
            if (index >= NullableVarCharVector.this.logicalNumValues) {
                throw new IndexOutOfBoundsException(String.format("Index [%d], number of values [%d]", index, NullableVarCharVector.this.logicalNumValues));
            }
        }
    }

    public final class AccessorImpl
    extends Accessor {
        @Override
        public byte[] get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        @Override
        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        @Override
        public long getStartEnd(int index) {
            return this.vAccessor.getStartEnd(index);
        }

        @Override
        public int getValueLength(int index) {
            return NullableVarCharVector.this.values.getAccessor().getValueLength(index);
        }

        @Override
        public void get(int index, NullableVarCharHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public Text getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableVarCharVector.this.bits.getAccessor().getValueCount();
        }
    }

    public abstract class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt1Vector.Accessor bAccessor;
        final VarCharVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableVarCharVector.this.bits.getAccessor();
            this.vAccessor = NullableVarCharVector.this.values.getAccessor();
        }

        public abstract byte[] get(int var1);

        public abstract int isSet(int var1);

        public abstract long getStartEnd(int var1);

        public abstract void get(int var1, NullableVarCharHolder var2);

        public void reset() {
        }

        @Override
        public abstract Text getObject(int var1);
    }

    private class TransferImpl
    implements TransferPair {
        NullableVarCharVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableVarCharVector(field, allocator);
            if (NullableVarCharVector.this.isDuplicateValsOnly() && NullableVarCharVector.this.logicalNumValues > 0) {
                this.to.setDuplicateValsOnly(true);
            }
        }

        public TransferImpl(NullableVarCharVector to) {
            this.to = to;
            if (NullableVarCharVector.this.isDuplicateValsOnly() && NullableVarCharVector.this.logicalNumValues > 0) {
                this.to.setDuplicateValsOnly(true);
            }
        }

        @Override
        public NullableVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableVarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableVarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableVarCharVector.this);
        }
    }
}

