/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.Arrays;
import java.util.Set;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.TimeVector;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableTimeReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableTimeVector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableTimeVector.class);
    private static final int DEFINED_VALUES_ARRAY_LEN = 1024;
    private static final byte[] DEFINED_VALUES_ARRAY = new byte[1024];
    private final FieldReader reader = new NullableTimeReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create("$bits$", Types.required(TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final TimeVector values = new TimeVector(this.field, this.allocator);
    private final Mutator mutator = new MutatorImpl();
    private final Accessor accessor = new AccessorImpl();

    boolean isDuplicateValsOnly() {
        return false;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public TimeVector getValuesVector() {
        return this.values;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableTimeVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TimeVector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableTimeVector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        NullableTimeVector fromVector = (NullableTimeVector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        NullableTimeVector target = (NullableTimeVector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    public NullableTimeVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableTimeVector)to);
    }

    public void transferTo(NullableTimeVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableTimeVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    public TimeVector convertToRequiredVector() {
        TimeVector v = new TimeVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    static {
        Arrays.fill(DEFINED_VALUES_ARRAY, (byte)1);
    }

    public final class MutatorImpl
    extends Mutator {
        private MutatorImpl() {
        }

        @Override
        public TimeVector getVectorWithValues() {
            return NullableTimeVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableTimeVector.this.bits.getMutator().set(index, 1);
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            int batchSz;
            for (int remaining = numValues; remaining > 0; remaining -= batchSz) {
                batchSz = Math.min(remaining, 1024);
                NullableTimeVector.this.bits.getMutator().set(index + (numValues - remaining), DEFINED_VALUES_ARRAY, 0, batchSz);
            }
        }

        @Override
        public void set(int index, int value) {
            ++this.setCount;
            TimeVector.Mutator valuesMutator = NullableTimeVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableTimeVector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        @Override
        public void setNull(int index) {
            NullableTimeVector.this.bits.getMutator().setSafe(index, 0);
        }

        @Override
        public void setSkipNull(int index, TimeHolder holder) {
            NullableTimeVector.this.values.getMutator().set(index, holder);
        }

        @Override
        public void setSkipNull(int index, NullableTimeHolder holder) {
            NullableTimeVector.this.values.getMutator().set(index, holder);
        }

        @Override
        public void setNullBounded(int index) throws VectorOverflowException {
            NullableTimeVector.this.bits.getMutator().setScalar(index, 0);
        }

        @Override
        public void set(int index, NullableTimeHolder holder) {
            TimeVector.Mutator valuesMutator = NullableTimeVector.this.values.getMutator();
            NullableTimeVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        @Override
        public void set(int index, TimeHolder holder) {
            TimeVector.Mutator valuesMutator = NullableTimeVector.this.values.getMutator();
            NullableTimeVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        @Override
        public boolean isSafe(int outIndex) {
            return outIndex < NullableTimeVector.this.getValueCapacity();
        }

        @Override
        public void set(int index, int isSet, int valueField) {
            TimeVector.Mutator valuesMutator = NullableTimeVector.this.values.getMutator();
            NullableTimeVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, valueField);
        }

        @Override
        public void setSafe(int index, int isSet, int valueField) {
            NullableTimeVector.this.bits.getMutator().setSafe(index, isSet);
            NullableTimeVector.this.values.getMutator().setSafe(index, valueField);
            ++this.setCount;
        }

        @Override
        public void setScalar(int index, int isSet, int valueField) throws VectorOverflowException {
            NullableTimeVector.this.values.getMutator().setScalar(index, valueField);
            NullableTimeVector.this.bits.getMutator().setSafe(index, isSet);
            ++this.setCount;
        }

        @Override
        public void setSafe(int index, NullableTimeHolder value) {
            NullableTimeVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableTimeVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        @Override
        public void setScalar(int index, NullableTimeHolder value) throws VectorOverflowException {
            NullableTimeVector.this.values.getMutator().setScalar(index, value);
            NullableTimeVector.this.bits.getMutator().setSafe(index, value.isSet);
            ++this.setCount;
        }

        @Override
        public void setSafe(int index, TimeHolder value) {
            NullableTimeVector.this.bits.getMutator().setSafe(index, 1);
            NullableTimeVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        @Override
        public void setScalar(int index, TimeHolder value) throws VectorOverflowException {
            NullableTimeVector.this.values.getMutator().setScalar(index, value);
            NullableTimeVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
        }

        @Override
        public void setSafe(int index, int value) {
            NullableTimeVector.this.bits.getMutator().setSafe(index, 1);
            NullableTimeVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        @Override
        public void setScalar(int index, int value) throws VectorOverflowException {
            NullableTimeVector.this.values.getMutator().setScalar(index, value);
            NullableTimeVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableTimeVector.this.values.getMutator().setValueCount(valueCount);
            NullableTimeVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableTimeVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableTimeVector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.setCount = 0;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
            Mutator target = (Mutator)other;
            int temp = this.setCount;
            this.setCount = target.setCount;
            target.setCount = temp;
        }
    }

    public abstract class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter {
        protected int setCount;

        private Mutator() {
        }

        public abstract TimeVector getVectorWithValues();

        public abstract void set(int var1, int var2);

        public abstract void setNull(int var1);

        public abstract void setSkipNull(int var1, TimeHolder var2);

        public abstract void setSkipNull(int var1, NullableTimeHolder var2);

        public abstract void setNullBounded(int var1) throws VectorOverflowException;

        public abstract void set(int var1, NullableTimeHolder var2);

        public abstract void set(int var1, TimeHolder var2);

        public abstract boolean isSafe(int var1);

        public abstract void set(int var1, int var2, int var3);

        public abstract void setSafe(int var1, int var2, int var3);

        public abstract void setScalar(int var1, int var2, int var3) throws VectorOverflowException;

        public abstract void setSafe(int var1, NullableTimeHolder var2);

        public abstract void setScalar(int var1, NullableTimeHolder var2) throws VectorOverflowException;

        public abstract void setSafe(int var1, TimeHolder var2);

        public abstract void setScalar(int var1, TimeHolder var2) throws VectorOverflowException;

        public abstract void setSafe(int var1, int var2);

        public abstract void setScalar(int var1, int var2) throws VectorOverflowException;
    }

    public final class AccessorImpl
    extends Accessor {
        @Override
        public int get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        @Override
        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        @Override
        public void get(int index, NullableTimeHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public DateTime getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableTimeVector.this.bits.getAccessor().getValueCount();
        }
    }

    public abstract class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final TimeVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableTimeVector.this.bits.getAccessor();
            this.vAccessor = NullableTimeVector.this.values.getAccessor();
        }

        public abstract int get(int var1);

        public abstract int isSet(int var1);

        public abstract void get(int var1, NullableTimeHolder var2);

        public void reset() {
        }

        @Override
        public abstract DateTime getObject(int var1);
    }

    private class TransferImpl
    implements TransferPair {
        NullableTimeVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableTimeVector(field, allocator);
        }

        public TransferImpl(NullableTimeVector to) {
            this.to = to;
        }

        @Override
        public NullableTimeVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableTimeVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableTimeVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableTimeVector.this);
        }
    }
}

