/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.BigIntReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigIntVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(BigIntVector.class);
    public static final int VALUE_WIDTH = 8;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 8;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 8 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new BigIntReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(32768, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public BigIntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 8;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 8;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 8L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 8);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        long l = newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0L) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 8;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((BigIntVector)to);
    }

    public void transferTo(BigIntVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BigIntVector target) {
        int startPoint = startIndex * 8;
        int sliceLength = length * 8;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 8;
    }

    public void copyFrom(int fromIndex, int thisIndex, BigIntVector from) {
        this.data.setLong(thisIndex * 8, from.data.getLong(fromIndex * 8));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, BigIntVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        ((BigIntVector)from).data.getBytes(fromIndex * 8, this.data, toIndex * 8, 8);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, long value) {
            BigIntVector.this.data.setLong(index * 8, value);
        }

        public void setSafe(int index, long value) {
            while (index >= BigIntVector.this.getValueCapacity()) {
                BigIntVector.this.reAlloc();
            }
            this.set(index, value);
        }

        public void setScalar(int index, long value) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, value);
        }

        public void setArrayItem(int index, long value) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, value);
        }

        protected void set(int index, BigIntHolder holder) {
            BigIntVector.this.data.setLong(index * 8, holder.value);
        }

        public void setSafe(int index, BigIntHolder holder) {
            while (index >= BigIntVector.this.getValueCapacity()) {
                BigIntVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void setScalar(int index, BigIntHolder holder) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        public void setArrayItem(int index, BigIntHolder holder) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        protected void set(int index, NullableBigIntHolder holder) {
            BigIntVector.this.data.setLong(index * 8, holder.value);
        }

        public void setSafe(int index, NullableBigIntHolder holder) {
            while (index >= BigIntVector.this.getValueCapacity()) {
                BigIntVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void setScalar(int index, NullableBigIntHolder holder) throws VectorOverflowException {
            if (index >= MAX_SCALAR_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        public void setArrayItem(int index, NullableBigIntHolder holder) throws VectorOverflowException {
            if (index >= MAX_VALUE_COUNT) {
                throw new VectorOverflowException();
            }
            this.setSafe(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = BigIntVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Long.MIN_VALUE);
                } else {
                    this.set(i, Long.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = BigIntVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1L);
                } else {
                    this.set(i, 0L);
                }
                even = !even;
            }
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            for (int i = lastWrite + 1; i <= index; ++i) {
                this.setSafe(i, 0L);
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = BigIntVector.this.getValueCapacity();
            int idx = 8 * valueCount;
            while (valueCount > BigIntVector.this.getValueCapacity()) {
                BigIntVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                BigIntVector.this.incrementAllocationMonitor();
            } else if (BigIntVector.this.allocationMonitor > 0) {
                BigIntVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(BigIntVector.this.data, idx);
            BigIntVector.this.data.writerIndex(valueCount * 8);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return BigIntVector.this.data.writerIndex() / 8;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public long get(int index) {
            return BigIntVector.this.data.getLong(index * 8);
        }

        @Override
        public Long getObject(int index) {
            return this.get(index);
        }

        public long getPrimitiveObject(int index) {
            return this.get(index);
        }

        public void get(int index, BigIntHolder holder) {
            holder.value = BigIntVector.this.data.getLong(index * 8);
        }

        public void get(int index, NullableBigIntHolder holder) {
            holder.isSet = 1;
            holder.value = BigIntVector.this.data.getLong(index * 8);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private BigIntVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new BigIntVector(field, allocator);
        }

        public TransferImpl(BigIntVector to) {
            this.to = to;
        }

        @Override
        public BigIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            BigIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            BigIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, BigIntVector.this);
        }
    }
}

