/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.LinkedList;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.physical.PhysicalPlan;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.server.options.OptionSet;
import oadd.org.apache.drill.exec.server.options.QueryOptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryAllocationUtilities {
    private static final Logger logger = LoggerFactory.getLogger(MemoryAllocationUtilities.class);

    public static void setupBufferedOpsMemoryAllocations(PhysicalPlan plan, QueryContext queryContext) {
        if (plan.getProperties().hasResourcePlan) {
            return;
        }
        LinkedList<PhysicalOperator> bufferedOpList = new LinkedList<PhysicalOperator>();
        for (PhysicalOperator op : plan.getSortedOperators()) {
            if (!op.isBufferedOperator()) continue;
            bufferedOpList.add(op);
        }
        plan.getProperties().hasResourcePlan = true;
        if (bufferedOpList.isEmpty()) {
            return;
        }
        QueryOptionManager optionManager = queryContext.getOptions();
        long directMemory = DrillConfig.getMaxDirectMemory();
        long maxAllocPerNode = MemoryAllocationUtilities.computeQueryMemory(queryContext.getConfig(), optionManager, directMemory);
        logger.debug("Memory per query per node: {}", (Object)maxAllocPerNode);
        long opMinMem = MemoryAllocationUtilities.computeOperatorMemory(optionManager, maxAllocPerNode, bufferedOpList.size());
        for (PhysicalOperator op : bufferedOpList) {
            long alloc = Math.max(opMinMem, op.getInitialAllocation());
            op.setMaxAllocation(alloc);
        }
    }

    public static long computeOperatorMemory(OptionSet optionManager, long maxAllocPerNode, int opCount) {
        long maxWidth = optionManager.getOption(ExecConstants.MAX_WIDTH_PER_NODE);
        double cpuLoadAverage = optionManager.getOption(ExecConstants.CPU_LOAD_AVERAGE);
        long maxWidthPerNode = ExecConstants.MAX_WIDTH_PER_NODE.computeMaxWidth(cpuLoadAverage, maxWidth);
        long maxOperatorAlloc = maxAllocPerNode / ((long)opCount * maxWidthPerNode);
        logger.debug("Max buffered operator alloc: {}", (Object)maxOperatorAlloc);
        return Math.max(maxOperatorAlloc, optionManager.getOption(ExecConstants.MIN_MEMORY_PER_BUFFERED_OP));
    }

    @VisibleForTesting
    public static long computeQueryMemory(DrillConfig config, OptionSet optionManager, long directMemory) {
        long perQueryMemory = Math.round((double)directMemory * optionManager.getOption(ExecConstants.PERCENT_MEMORY_PER_QUERY));
        perQueryMemory = Math.max(perQueryMemory, optionManager.getOption(ExecConstants.MAX_QUERY_MEMORY_PER_NODE));
        long maxAllocPerNode = Math.min(directMemory, config.getLong("drill.memory.top.max"));
        maxAllocPerNode = Math.min(maxAllocPerNode, perQueryMemory);
        return maxAllocPerNode;
    }
}

