/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class FileSystemUtil {
    public static final PathFilter DUMMY_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }
    };

    public static List<FileStatus> listDirectories(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        FileSystemUtil.listDirectories(fs, path, recursive, statuses, FileSystemUtil.mergeFilters(filters));
        return statuses;
    }

    public static List<FileStatus> listFiles(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        FileSystemUtil.listFiles(fs, path, recursive, statuses, FileSystemUtil.mergeFilters(filters));
        return statuses;
    }

    public static List<FileStatus> listAll(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        FileSystemUtil.listAll(fs, path, recursive, statuses, FileSystemUtil.mergeFilters(filters));
        return statuses;
    }

    public static PathFilter mergeFilters(PathFilter filter, PathFilter[] filters) {
        if (filters == null || filters.length == 0) {
            return filter;
        }
        int length = filters.length;
        PathFilter[] newFilters = Arrays.copyOf(filters, length + 1);
        newFilters[length] = filter;
        return FileSystemUtil.mergeFilters(newFilters);
    }

    public static PathFilter mergeFilters(final PathFilter ... filters) {
        if (filters.length == 0) {
            return DUMMY_FILTER;
        }
        return new PathFilter(){

            public boolean accept(Path path) {
                for (PathFilter filter : filters) {
                    if (filter.accept(path)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static List<FileStatus> listDirectories(FileSystem fs, Path path, boolean recursive, List<FileStatus> statuses, PathFilter filter) throws IOException {
        FileStatus[] fileStatuses;
        for (FileStatus status : fileStatuses = fs.listStatus(path, filter)) {
            if (!status.isDirectory()) continue;
            statuses.add(status);
            if (!recursive) continue;
            FileSystemUtil.listDirectories(fs, status.getPath(), true, statuses, filter);
        }
        return statuses;
    }

    private static List<FileStatus> listFiles(FileSystem fs, Path path, boolean recursive, List<FileStatus> statuses, PathFilter filter) throws IOException {
        FileStatus[] fileStatuses;
        for (FileStatus status : fileStatuses = fs.listStatus(path, filter)) {
            if (status.isDirectory()) {
                if (!recursive) continue;
                FileSystemUtil.listFiles(fs, status.getPath(), true, statuses, filter);
                continue;
            }
            statuses.add(status);
        }
        return statuses;
    }

    private static List<FileStatus> listAll(FileSystem fs, Path path, boolean recursive, List<FileStatus> statuses, PathFilter filter) throws IOException {
        for (FileStatus status : fs.listStatus(path, filter)) {
            statuses.add(status);
            if (!status.isDirectory() || !recursive) continue;
            FileSystemUtil.listAll(fs, status.getPath(), true, statuses, filter);
        }
        return statuses;
    }
}

