/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.IOException;
import java.util.List;
import oadd.org.apache.drill.exec.util.FileSystemUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class DrillFileSystemUtil {
    public static final PathFilter DRILL_SYSTEM_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return !path.getName().startsWith("_") && !path.getName().startsWith(".");
        }
    };

    public static List<FileStatus> listDirectories(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        return FileSystemUtil.listDirectories(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listFiles(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        return FileSystemUtil.listFiles(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }

    public static List<FileStatus> listAll(FileSystem fs, Path path, boolean recursive, PathFilter ... filters) throws IOException {
        return FileSystemUtil.listAll(fs, path, recursive, FileSystemUtil.mergeFilters(DRILL_SYSTEM_FILTER, filters));
    }
}

