/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ssl;

import java.text.MessageFormat;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.handler.ssl.SslContext;
import oadd.io.netty.handler.ssl.SslContextBuilder;
import oadd.io.netty.handler.ssl.SslProvider;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.DrillException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ssl.SSLConfig;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfigServer
extends SSLConfig {
    private static final Logger logger = LoggerFactory.getLogger(SSLConfigServer.class);
    private final DrillConfig config;
    private final Configuration hadoopConfig;
    private final boolean userSslEnabled;
    private final boolean httpsEnabled;
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String trustStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String protocol;
    private final String provider;

    public SSLConfigServer(DrillConfig config, Configuration hadoopConfig) throws DrillException {
        this.config = config;
        SSLConfig.Mode mode = SSLConfig.Mode.SERVER;
        this.httpsEnabled = config.hasPath("drill.exec.http.ssl_enabled") && config.getBoolean("drill.exec.http.ssl_enabled");
        boolean enableHadoopConfig = config.getBoolean("drill.exec.ssl.useHadoopConfig");
        if (enableHadoopConfig) {
            this.hadoopConfig = hadoopConfig == null ? new Configuration() : hadoopConfig;
            String hadoopSSLConfigFile = this.hadoopConfig.get(this.resolveHadoopPropertyName("hadoop.ssl.{0}.conf", this.getMode()));
            logger.debug("Using Hadoop configuration for SSL");
            logger.debug("Hadoop SSL configuration file: {}", (Object)hadoopSSLConfigFile);
            this.hadoopConfig.addResource(hadoopSSLConfigFile);
        } else {
            this.hadoopConfig = null;
        }
        this.userSslEnabled = config.hasPath("drill.exec.security.user.encryption.ssl.enabled") && config.getBoolean("drill.exec.security.user.encryption.ssl.enabled");
        this.trustStoreType = this.getConfigParam("drill.exec.ssl.trustStoreType", this.resolveHadoopPropertyName("ssl.{0}.truststore.type", mode));
        this.trustStorePath = this.getConfigParam("drill.exec.ssl.trustStorePath", this.resolveHadoopPropertyName("ssl.{0}.truststore.location", mode));
        this.trustStorePassword = this.getConfigParam("drill.exec.ssl.trustStorePassword", this.resolveHadoopPropertyName("ssl.{0}.truststore.password", mode));
        this.keyStoreType = this.getConfigParam("drill.exec.ssl.keyStoreType", this.resolveHadoopPropertyName("ssl.{0}.keystore.type", mode));
        this.keyStorePath = this.getConfigParam("drill.exec.ssl.keyStorePath", this.resolveHadoopPropertyName("ssl.{0}.keystore.location", mode));
        this.keyStorePassword = this.getConfigParam("drill.exec.ssl.keyStorePassword", this.resolveHadoopPropertyName("ssl.{0}.keystore.password", mode));
        String keyPass = this.getConfigParam("drill.exec.ssl.keyPassword", this.resolveHadoopPropertyName("ssl.{0}.keystore.keypassword", mode));
        this.keyPassword = keyPass.isEmpty() ? this.keyStorePassword : keyPass;
        this.protocol = this.getConfigParamWithDefault("drill.exec.ssl.protocol", "TLSv1.2");
        this.provider = this.getConfigParamWithDefault("drill.exec.ssl.provider", "JDK");
    }

    @Override
    public void validateKeyStore() throws DrillException {
        if (!(!this.isUserSslEnabled() && !this.isHttpsEnabled() || this.keyStorePath.isEmpty() && this.keyStorePassword.isEmpty())) {
            if (this.keyStorePath.isEmpty()) {
                throw new DrillException(" *.ssl.keyStorePath in the configuration file is empty, but *.ssl.keyStorePassword is set");
            }
            if (this.keyStorePassword.isEmpty()) {
                throw new DrillException(" *.ssl.keyStorePassword in the configuration file is empty, but *.ssl.keyStorePath is set ");
            }
        }
    }

    @Override
    public SslContext initNettySslContext() throws DrillException {
        SslContext sslCtx;
        if (!this.userSslEnabled) {
            return null;
        }
        try {
            if (this.keyStorePath.isEmpty()) {
                throw new DrillException("No Keystore provided.");
            }
            KeyManagerFactory kmf = this.initializeKeyManagerFactory();
            TrustManagerFactory tmf = this.initializeTrustManagerFactory();
            sslCtx = SslContextBuilder.forServer(kmf).trustManager(tmf).protocols(this.protocol).sslProvider(this.getProvider()).build();
        }
        catch (Exception e) {
            throw new DrillException("SSL is enabled but cannot be initialized - " + "[ " + e.getMessage() + "]. ");
        }
        this.nettySslContext = sslCtx;
        return sslCtx;
    }

    @Override
    public SSLContext initJDKSSLContext() throws DrillException {
        SSLContext sslCtx;
        if (!this.userSslEnabled) {
            return null;
        }
        try {
            if (this.keyStorePath.isEmpty()) {
                throw new DrillException("No Keystore provided.");
            }
            KeyManagerFactory kmf = this.initializeKeyManagerFactory();
            TrustManagerFactory tmf = this.initializeTrustManagerFactory();
            sslCtx = SSLContext.getInstance(this.protocol);
            sslCtx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new DrillException("SSL is enabled but cannot be initialized - " + "[ " + e.getMessage() + "]. ");
        }
        this.jdkSSlContext = sslCtx;
        return sslCtx;
    }

    @Override
    public SSLEngine createSSLEngine(BufferAllocator allocator, String peerHost, int peerPort) {
        SSLEngine engine = super.createSSLEngine(allocator, peerHost, peerPort);
        engine.setUseClientMode(false);
        engine.setNeedClientAuth(false);
        try {
            engine.setEnableSessionCreation(true);
        }
        catch (Exception e) {
            logger.debug("Session creation not enabled. Exception: {}", (Object)e.getMessage());
        }
        return engine;
    }

    private String getConfigParam(String name, String hadoopName) {
        String value = "";
        if (this.hadoopConfig != null) {
            value = this.getHadoopConfigParam(hadoopName);
        }
        if (value.isEmpty() && this.config.hasPath(name)) {
            value = this.config.getString(name);
        }
        value = value.trim();
        return value;
    }

    private String getHadoopConfigParam(String name) {
        Preconditions.checkArgument(this.hadoopConfig != null);
        String value = this.hadoopConfig.get(name, "");
        value = value.trim();
        return value;
    }

    private String getConfigParamWithDefault(String name, String defaultValue) {
        String value = "";
        if (this.config.hasPath(name)) {
            value = this.config.getString(name);
        }
        if (value.isEmpty()) {
            value = defaultValue;
        }
        value = value.trim();
        return value;
    }

    private String resolveHadoopPropertyName(String nameTemplate, SSLConfig.Mode mode) {
        return MessageFormat.format(nameTemplate, mode.toString().toLowerCase());
    }

    @Override
    public boolean isUserSslEnabled() {
        return this.userSslEnabled;
    }

    @Override
    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Override
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Override
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Override
    public boolean hasTrustStorePath() {
        return !this.trustStorePath.isEmpty();
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    public boolean hasTrustStorePassword() {
        return !this.trustStorePassword.isEmpty();
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public SslProvider getProvider() {
        return this.provider.equalsIgnoreCase("JDK") ? SslProvider.JDK : SslProvider.OPENSSL;
    }

    @Override
    public int getHandshakeTimeout() {
        return 0;
    }

    @Override
    public SSLConfig.Mode getMode() {
        return SSLConfig.Mode.SERVER;
    }

    @Override
    public boolean disableHostVerification() {
        return false;
    }

    @Override
    public boolean disableCertificateVerification() {
        return false;
    }

    @Override
    public boolean useSystemTrustStore() {
        return false;
    }

    @Override
    public boolean isSslValid() {
        return !this.keyStorePath.isEmpty() && !this.keyStorePassword.isEmpty();
    }
}

