/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Stopwatch;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.util.DrillVersionInfo;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.ControllerImpl;
import oadd.org.apache.drill.exec.rpc.data.DataConnectionCreator;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.work.WorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEngine
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    private static final boolean DISABLE_LOOPBACK_CHECK = "true".equals(System.getProperty("drill.disable_loopback_check"));
    private final UserServer userServer;
    private final Controller controller;
    private final DataConnectionCreator dataPool;
    private final String hostName;
    private final int intialUserPort;
    private final boolean allowPortHunting;
    private final boolean isDistributedMode;
    private final BufferAllocator userAllocator;
    private final BufferAllocator controlAllocator;
    private final BufferAllocator dataAllocator;
    private int userPort;

    public ServiceEngine(WorkManager manager, BootStrapContext context, boolean allowPortHunting, boolean isDistributedMode) throws DrillbitStartupException {
        this.userAllocator = ServiceEngine.newAllocator(context, "rpc:user", "drill.exec.rpc.user.server.memory.reservation", "drill.exec.rpc.user.server.memory.maximum");
        this.controlAllocator = ServiceEngine.newAllocator(context, "rpc:bit-control", "drill.exec.rpc.bit.server.memory.control.reservation", "drill.exec.rpc.bit.server.memory.control.maximum");
        this.dataAllocator = ServiceEngine.newAllocator(context, "rpc:bit-data", "drill.exec.rpc.bit.server.memory.data.reservation", "drill.exec.rpc.bit.server.memory.data.maximum");
        EventLoopGroup eventLoopGroup = TransportCheck.createEventLoopGroup(context.getConfig().getInt("drill.exec.rpc.user.server.threads"), "UserServer-");
        this.userServer = new UserServer(context, this.userAllocator, eventLoopGroup, manager.getUserWorker());
        this.controller = new ControllerImpl(context, this.controlAllocator, manager.getControlMessageHandler());
        this.dataPool = new DataConnectionCreator(context, this.dataAllocator, manager.getWorkBus(), manager.getBee());
        this.hostName = context.getHostName();
        this.intialUserPort = context.getConfig().getInt("drill.exec.rpc.user.server.port");
        this.allowPortHunting = allowPortHunting;
        this.isDistributedMode = isDistributedMode;
    }

    private static BufferAllocator newAllocator(BootStrapContext context, String name, String initReservation, String maxAllocation) {
        return context.getAllocator().newChildAllocator(name, context.getConfig().getLong(initReservation), context.getConfig().getLong(maxAllocation));
    }

    public CoordinationProtos.DrillbitEndpoint start() throws DrillbitStartupException, UnknownHostException {
        if (this.isDistributedMode && InetAddress.getByName(this.hostName).isLoopbackAddress()) {
            throw new DrillbitStartupException("Drillbit is disallowed to bind to loopback address in distributed mode.");
        }
        this.userPort = this.userServer.bind(this.intialUserPort, this.allowPortHunting);
        CoordinationProtos.DrillbitEndpoint partialEndpoint = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(this.hostName).setUserPort(this.userPort).setVersion(DrillVersionInfo.getVersion()).setState(CoordinationProtos.DrillbitEndpoint.State.STARTUP).build();
        partialEndpoint = this.controller.start(partialEndpoint, this.allowPortHunting);
        return this.dataPool.start(partialEndpoint, this.allowPortHunting);
    }

    public int getUserPort() {
        return this.userPort;
    }

    public DataConnectionCreator getDataConnectionCreator() {
        return this.dataPool;
    }

    public Controller getController() {
        return this.controller;
    }

    private void submit(Executor p, final String name, final AutoCloseable c) {
        p.execute(new Runnable(){

            @Override
            public void run() {
                Stopwatch watch = Stopwatch.createStarted();
                try {
                    c.close();
                }
                catch (Exception e) {
                    logger.warn("Failure while closing {}.", (Object)name, (Object)e);
                }
                long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
                if (elapsed > 500L) {
                    logger.info("closed " + name + " in " + elapsed + " ms");
                }
            }
        });
    }

    private void checkLoopbackAddress(String address) throws DrillbitStartupException, UnknownHostException {
        if (!DISABLE_LOOPBACK_CHECK && this.isDistributedMode && InetAddress.getByName(address).isLoopbackAddress()) {
            throw new DrillbitStartupException("Drillbit is disallowed to bind to loopback address in distributed mode.");
        }
    }

    @Override
    public void close() throws Exception {
        ExecutorService p = Executors.newFixedThreadPool(2);
        this.submit(p, "userServer", this.userServer);
        this.submit(p, "dataPool", (AutoCloseable)this.dataPool);
        this.submit(p, "controller", (AutoCloseable)this.controller);
        p.shutdown();
        try {
            p.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        AutoCloseables.close(this.userAllocator, this.controlAllocator, this.dataAllocator);
    }
}

