/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.clusterclient.zkbased;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.ParametersAreNonnullByDefault;
import oadd.com.google.common.cache.Cache;
import oadd.com.google.common.cache.CacheBuilder;
import oadd.com.google.common.cache.RemovalListener;
import oadd.com.google.common.cache.RemovalNotification;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.common.exceptions.DrillIOException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.NonTransientRpcException;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.AbstractDrillClusterClient;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillConnectionImpl;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillConnectionPool;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.EndpointProvider;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.zkbased.ZKBasedConnectionPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKBasedConnectionPool
extends AbstractDrillClusterClient
implements DrillConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(ZKBasedConnectionPool.class);
    private final EndpointProvider endpoints;
    private final DrillProperties connectionProperties;
    private final Cache<CoordinationProtos.DrillbitEndpoint, DrillConnectionImpl> connections;
    private final boolean ownsEndpointProvider;

    ZKBasedConnectionPool(ZKBasedConnectionPoolBuilder builder) {
        super(builder);
        this.endpoints = builder.endpointProvider;
        this.connectionProperties = builder.connectionProperties;
        this.ownsEndpointProvider = builder.ownsEndpointProvider;
        this.connectionProperties.setProperty("multiplex", "true");
        this.connections = CacheBuilder.newBuilder().removalListener(new RemovalListener<CoordinationProtos.DrillbitEndpoint, DrillConnectionImpl>(){

            @Override
            @ParametersAreNonnullByDefault
            public void onRemoval(RemovalNotification<CoordinationProtos.DrillbitEndpoint, DrillConnectionImpl> notification) {
                if (notification.wasEvicted()) {
                    logger.warn("Connection was evicted. Closing connection, and failing all running queries.");
                    DrillConnectionImpl connection = notification.getValue();
                    if (connection != null) {
                        connection.close(false);
                    }
                }
            }
        }).build();
    }

    @Override
    public BufferAllocator getAllocator() {
        return super.getAllocator();
    }

    @Override
    public DrillSession newSession(final Properties info) throws DrillIOException {
        DrillConnectionImpl connection;
        final CoordinationProtos.DrillbitEndpoint endpoint = this.endpoints.getEndpoint();
        if (endpoint == null) {
            throw new NonTransientRpcException("Invalid endpoint information; did not expect 'null'");
        }
        try {
            connection = this.connections.get(endpoint, new Callable<DrillConnectionImpl>(){

                @Override
                public DrillConnectionImpl call() throws Exception {
                    DrillConnectionImpl newConnection = ZKBasedConnectionPool.this.newPhysicalConnection(endpoint, info);
                    newConnection.connect(endpoint, ZKBasedConnectionPool.this.connectionProperties, ZKBasedConnectionPool.getUserCredentials(ZKBasedConnectionPool.this.connectionProperties));
                    return newConnection;
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DrillIOException) {
                throw (DrillIOException)e.getCause();
            }
            throw new DrillIOException("Unexpected error: " + e.getCause().getMessage());
        }
        return connection.newSession(info);
    }

    @Override
    protected void connectionClosedDirectly(CoordinationProtos.DrillbitEndpoint endpoint) {
        this.connections.invalidate(endpoint);
    }

    @Override
    protected void closeAllConnections() {
        for (DrillConnectionImpl connection : this.connections.asMap().values()) {
            connection.close(false);
        }
        this.connections.invalidateAll();
    }

    @Override
    public void close() {
        if (this.ownsEndpointProvider) {
            this.endpoints.close();
        }
        super.close();
    }
}

