/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.clusterclient;

import java.util.concurrent.ExecutorService;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillClusterClient;

public abstract class AbstractDrillClusterClientBuilder<B extends AbstractDrillClusterClientBuilder<B, C>, C extends DrillClusterClient> {
    String name = "Apache Drill Java client";
    DrillConfig config;
    BufferAllocator allocator;
    EventLoopGroup eventLoopGroup;
    ExecutorService executor;
    int eventLoopGroupSize = 5;
    boolean supportComplexTypes = true;

    protected abstract B getThis();

    public B setName(String clientName) {
        this.name = clientName;
        return this.getThis();
    }

    public B setConfig(DrillConfig drillConfig) {
        this.config = drillConfig;
        return this.getThis();
    }

    public B setConfigFromFile(String fileName) {
        this.config = DrillConfig.create(fileName);
        return this.getThis();
    }

    public B setAllocator(BufferAllocator allocator) {
        this.allocator = allocator;
        return this.getThis();
    }

    public B setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this.getThis();
    }

    public B setEventLoopGroupSize(int eventLoopGroupSize) {
        this.eventLoopGroupSize = eventLoopGroupSize;
        return this.getThis();
    }

    public B setExecutorService(ExecutorService executor) {
        this.executor = executor;
        return this.getThis();
    }

    public B setSupportsComplexTypes(boolean supportComplexTypes) {
        this.supportComplexTypes = supportComplexTypes;
        return this.getThis();
    }

    public abstract C build();
}

