/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security.kerberos;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import oadd.org.apache.drill.common.KerberosUtil;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.FastSaslClientFactory;
import oadd.org.apache.drill.exec.rpc.security.FastSaslServerFactory;
import oadd.org.apache.drill.exec.rpc.security.SecurityConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosFactory
implements AuthenticatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(KerberosFactory.class);
    private static final String DRILL_SERVICE_NAME = System.getProperty("drill.principal.primary", "mapr");

    @Override
    public String getSimpleName() {
        return "KERBEROS";
    }

    @Override
    public UserGroupInformation createAndLoginUser(Map<String, ?> properties) throws IOException {
        SecurityConfiguration conf = new SecurityConfiguration();
        conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
        conf.set("hadoop.login", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        String keytab = (String)properties.get("keytab");
        boolean assumeSubject = properties.containsKey("from_subject") && Boolean.parseBoolean((String)properties.get("from_subject"));
        try {
            UserGroupInformation ugi;
            if (assumeSubject) {
                ugi = UserGroupInformation.getUGIFromSubject((Subject)Subject.getSubject(AccessController.getContext()));
                logger.debug("Assuming subject for {}.", (Object)ugi.getShortUserName());
            } else if (keytab != null) {
                ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)((String)properties.get("user")), (String)keytab);
                logger.debug("Logged in {} using keytab.", (Object)ugi.getShortUserName());
            } else {
                ugi = UserGroupInformation.getCurrentUser();
                logger.debug("Logged in {} using ticket.", (Object)ugi.getShortUserName());
            }
            return ugi;
        }
        catch (IOException e) {
            logger.debug("Login failed.", e);
            Throwable cause = e.getCause();
            if (cause instanceof LoginException) {
                throw new SaslException("Failed to login.", cause);
            }
            throw new SaslException("Unexpected failure trying to login.", cause);
        }
    }

    @Override
    public SaslServer createSaslServer(UserGroupInformation ugi, final Map<String, ?> properties) throws SaslException {
        String qopValue = properties.containsKey("javax.security.sasl.qop") ? properties.get("javax.security.sasl.qop").toString() : "auth";
        try {
            final String primaryName = ugi.getShortUserName();
            final String instanceName = new HadoopKerberosName(ugi.getUserName()).getHostName();
            SaslServer saslServer = (SaslServer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws Exception {
                    return FastSaslServerFactory.getInstance().createSaslServer("GSSAPI", primaryName, instanceName, properties, new KerberosServerCallbackHandler());
                }
            });
            logger.trace("GSSAPI SaslServer created with QOP {}.", (Object)qopValue);
            return saslServer;
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getCause();
            logger.debug("Authentication failed.", cause);
            if (cause instanceof SaslException) {
                throw (SaslException)cause;
            }
            throw new SaslException(String.format("Unexpected failure trying to authenticate using Kerberos with QOP %s", qopValue), cause);
        }
        catch (IOException | InterruptedException e) {
            logger.debug("Authentication failed.", e);
            throw new SaslException(String.format("Unexpected failure trying to authenticate using Kerberos with QOP %s", qopValue), e);
        }
    }

    @Override
    public SaslClient createSaslClient(UserGroupInformation ugi, final Map<String, ?> properties) throws SaslException {
        String servicePrincipal = KerberosFactory.getServicePrincipal(properties);
        String[] parts = KerberosUtil.splitPrincipalIntoParts(servicePrincipal);
        final String serviceName = parts[0];
        final String serviceHostName = parts[1];
        String qopValue = properties.containsKey("javax.security.sasl.qop") ? properties.get("javax.security.sasl.qop").toString() : "auth";
        try {
            SaslClient saslClient = (SaslClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws Exception {
                    return FastSaslClientFactory.getInstance().createSaslClient(new String[]{"GSSAPI"}, null, serviceName, serviceHostName, properties, new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            throw new UnsupportedCallbackException(callbacks[0]);
                        }
                    });
                }
            });
            logger.debug("GSSAPI SaslClient created to authenticate to {} running on {} with QOP value {}", serviceName, serviceHostName, qopValue);
            return saslClient;
        }
        catch (UndeclaredThrowableException e) {
            logger.debug("Authentication failed.", e);
            throw new SaslException(String.format("Unexpected failure trying to authenticate to %s using GSSAPI with QOP %s", serviceHostName, qopValue), e.getCause());
        }
        catch (IOException | InterruptedException e) {
            logger.debug("Authentication failed.", e);
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException(String.format("Unexpected failure trying to authenticate to %s using GSSAPI with QOP %s", serviceHostName, qopValue), e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    private static String getServicePrincipal(Map<String, ?> properties) throws SaslException {
        String principal = (String)properties.get("principal");
        if (principal != null) {
            return principal;
        }
        String serviceHostname = (String)properties.get("service_host");
        if (serviceHostname == null) {
            throw new SaslException("Unknown Drillbit hostname. Check connection parameters?");
        }
        String serviceName = (String)properties.get("service_name");
        String realm = (String)properties.get("realm");
        try {
            return KerberosUtil.getPrincipalFromParts(serviceName == null ? DRILL_SERVICE_NAME : serviceName, serviceHostname.toLowerCase(), realm == null ? KerberosUtil.getDefaultRealm() : realm);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SaslException("Could not resolve realm information. Please set explicitly in connection parameters.");
        }
    }

    private static class KerberosServerCallbackHandler
    implements CallbackHandler {
        private KerberosServerCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                AuthorizeCallback authorizeCallback;
                if (callback instanceof AuthorizeCallback) {
                    authorizeCallback = (AuthorizeCallback)callback;
                    if (!authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID())) {
                        throw new SaslException("Drill expects authorization ID and authentication ID to match. Use inbound impersonation feature so one entity can act on behalf of another.");
                    }
                } else {
                    throw new UnsupportedCallbackException(callback);
                }
                authorizeCallback.setAuthorized(true);
            }
        }
    }
}

