/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.Closeable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.util.concurrent.AbstractFuture;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.ClientConnection;
import oadd.org.apache.drill.exec.rpc.RpcCommand;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconnectingConnection<C extends ClientConnection, HS extends MessageLite>
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(ReconnectingConnection.class);
    private final AtomicReference<C> connectionHolder = new AtomicReference();
    private final String host;
    private final int port;
    private final HS handshake;

    public ReconnectingConnection(HS handshake, String host, int port) {
        Preconditions.checkNotNull(host);
        Preconditions.checkArgument(port > 0);
        this.host = host;
        this.port = port;
        this.handshake = handshake;
    }

    protected abstract BasicClient<?, C, HS, ?> getNewClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MessageLite, R extends RpcCommand<T, C>> void runCommand(R cmd) {
        ClientConnection connection = (ClientConnection)this.connectionHolder.get();
        if (connection != null) {
            if (connection.isActive()) {
                cmd.connectionAvailable((ClientConnection)connection);
                return;
            }
            this.connectionHolder.compareAndSet(connection, null);
        }
        ReconnectingConnection reconnectingConnection = this;
        synchronized (reconnectingConnection) {
            connection = (ClientConnection)this.connectionHolder.get();
            if (connection != null) {
                cmd.connectionAvailable((ClientConnection)connection);
            } else {
                BasicClient<?, C, HS, ?> client = this.getNewClient();
                ConnectionListeningFuture future = new ConnectionListeningFuture(client.getInitialCommand(cmd));
                client.connectAsClient(future, this.handshake, this.host, this.port);
                future.waitAndRun();
            }
            return;
        }
    }

    public CloseHandlerCreator getCloseHandlerCreator() {
        return new CloseHandlerCreator();
    }

    public void addExternalConnection(C connection) {
        this.connectionHolder.compareAndSet(null, connection);
    }

    @Override
    public void close() {
        ClientConnection c = this.connectionHolder.getAndSet(null);
        if (c != null) {
            c.getChannel().close();
        }
    }

    protected static class CloseHandler
    implements GenericFutureListener<ChannelFuture> {
        private C connection;
        private GenericFutureListener<ChannelFuture> parent;
        final /* synthetic */ ReconnectingConnection this$0;

        public CloseHandler(C connection, GenericFutureListener<ChannelFuture> parent) {
            this.this$0 = this$0;
            this.connection = connection;
            this.parent = parent;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            this.this$0.connectionHolder.compareAndSet(this.connection, null);
            this.parent.operationComplete(future);
        }
    }

    public class CloseHandlerCreator {
        public GenericFutureListener<ChannelFuture> getHandler(C connection, GenericFutureListener<ChannelFuture> parent) {
            return new CloseHandler(ReconnectingConnection.this, connection, parent);
        }
    }

    public class ConnectionListeningFuture<R extends MessageLite>
    extends AbstractFuture<C>
    implements RpcConnectionHandler<C> {
        private RpcCommand<R, C> cmd;

        public ConnectionListeningFuture(RpcCommand<R, C> cmd) {
            this.cmd = cmd;
        }

        public void waitAndRun() {
            boolean isInterrupted = false;
            long remainingWaitTimeMills = 120000L;
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    ClientConnection connection = (ClientConnection)this.get(remainingWaitTimeMills, TimeUnit.MILLISECONDS);
                    if (connection == null) break;
                    this.cmd.connectionSucceeded(connection);
                }
                catch (InterruptedException interruptEx) {
                    startTime = System.currentTimeMillis();
                    isInterrupted = true;
                    if ((remainingWaitTimeMills -= System.currentTimeMillis() - startTime) >= 1L) continue;
                    this.cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, interruptEx);
                }
                catch (ExecutionException | TimeoutException ex) {
                    logger.error("Failed to establish connection", ex);
                    this.cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                }
                break;
            }
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            this.set(null);
            this.cmd.connectionFailed(type, t);
        }

        @Override
        public void connectionSucceeded(C incoming) {
            ClientConnection connection = (ClientConnection)ReconnectingConnection.this.connectionHolder.get();
            do {
                boolean setted;
                if (!(setted = ReconnectingConnection.this.connectionHolder.compareAndSet(null, incoming))) continue;
                connection = incoming;
                break;
            } while ((connection = (ClientConnection)ReconnectingConnection.this.connectionHolder.get()) == null);
            if (connection != incoming) {
                logger.debug("Closing incoming connection because a connection was already set.");
                incoming.getChannel().close();
            }
            this.set(connection);
        }
    }
}

