/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.com.google.protobuf.Parser;
import oadd.io.netty.bootstrap.Bootstrap;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.channel.Channel;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.ChannelInitializer;
import oadd.io.netty.channel.ChannelOption;
import oadd.io.netty.channel.ChannelPipeline;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.handler.timeout.IdleState;
import oadd.io.netty.handler.timeout.IdleStateEvent;
import oadd.io.netty.handler.timeout.IdleStateHandler;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.AbstractHandshakeHandler;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.ClientConnection;
import oadd.org.apache.drill.exec.rpc.ConnectionMultiListener;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.RpcBus;
import oadd.org.apache.drill.exec.rpc.RpcCommand;
import oadd.org.apache.drill.exec.rpc.RpcConfig;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcDecoder;
import oadd.org.apache.drill.exec.rpc.RpcEncoder;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcExceptionHandler;
import oadd.org.apache.drill.exec.rpc.RpcOutcome;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicClient<T extends Internal.EnumLite, CC extends ClientConnection, HS extends MessageLite, HR extends MessageLite>
extends RpcBus<T, CC> {
    private static final Logger logger = LoggerFactory.getLogger(BasicClient.class);
    private static final double PERCENT_TIMEOUT_BEFORE_SENDING_PING = 0.5;
    private final Bootstrap b;
    protected CC connection;
    private final T handshakeType;
    private final Class<HR> responseClass;
    private final Parser<HR> handshakeParser;
    private final IdlePingHandler pingHandler;
    private ConnectionMultiListener.SSLHandshakeListener sslHandshakeListener = null;
    private static final OutboundRpcMessage PING_MESSAGE = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PING, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);

    public BasicClient(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HR> responseClass, Parser<HR> handshakeParser) {
        super(rpcMapping);
        this.responseClass = responseClass;
        this.handshakeType = handshakeType;
        this.handshakeParser = handshakeParser;
        long timeoutInMillis = rpcMapping.hasTimeout() ? (long)((double)rpcMapping.getTimeout() * 1000.0 * 0.5) : -1L;
        this.pingHandler = rpcMapping.hasTimeout() ? new IdlePingHandler(timeoutInMillis) : null;
        this.b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(TransportCheck.getClientSocketChannel())).option(ChannelOption.ALLOCATOR, alloc)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicClient.this.connection = BasicClient.this.initRemoteConnection(ch);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)BasicClient.this.getCloseHandler(ch, BasicClient.this.connection));
                ChannelPipeline pipe = ch.pipeline();
                if (BasicClient.this.isSslEnabled()) {
                    BasicClient.this.setupSSL(pipe, BasicClient.this.sslHandshakeListener);
                }
                pipe.addLast("protocol-decoder", (ChannelHandler)BasicClient.this.getDecoder(BasicClient.this.connection.getAllocator()));
                pipe.addLast("message-decoder", (ChannelHandler)new RpcDecoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast("handshake-handler", (ChannelHandler)new ClientHandshakeHandler(BasicClient.this, BasicClient.this.connection));
                if (BasicClient.this.pingHandler != null) {
                    pipe.addLast("idle-state-handler", (ChannelHandler)BasicClient.this.pingHandler);
                }
                pipe.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)BasicClient.this, BasicClient.this.connection));
                pipe.addLast("exception-handler", new RpcExceptionHandler(BasicClient.this.connection));
            }
        });
    }

    protected void setupSSL(ChannelPipeline pipe, ConnectionMultiListener.SSLHandshakeListener sslHandshakeListener) {
        throw new UnsupportedOperationException("SSL is implemented only by the User Client.");
    }

    protected boolean isSslEnabled() {
        return false;
    }

    public void setSslChannel(Channel c) {
    }

    @Override
    protected CC initRemoteConnection(SocketChannel channel) {
        this.local = channel.localAddress();
        this.remote = channel.remoteAddress();
        return null;
    }

    public abstract ProtobufLengthDecoder getDecoder(BufferAllocator var1);

    public boolean isActive() {
        return this.connection != null && this.connection.isActive();
    }

    protected abstract void validateHandshake(HR var1) throws RpcException;

    protected void finalizeConnection(HR handshake, CC connection) {
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, SEND protobufBody, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, this.handshakeType, protobufBody, this.responseClass, allowInEventLoop, dataBodies);
    }

    protected <M extends MessageLite> RpcCommand<M, CC> getInitialCommand(RpcCommand<M, CC> command) {
        return command;
    }

    protected void connectAsClient(RpcConnectionHandler<CC> connectionListener, HS handshakeValue, String host, int port) {
        ConnectionMultiListener cml;
        ConnectionMultiListener.Builder builder = ConnectionMultiListener.newBuilder(connectionListener, handshakeValue, this);
        if (this.isSslEnabled()) {
            cml = builder.enableSSL().build();
            this.sslHandshakeListener = new ConnectionMultiListener.SSLHandshakeListener();
            this.sslHandshakeListener.setParent(cml);
        } else {
            cml = builder.build();
        }
        this.b.connect(host, port).addListener(cml.connectionHandler);
    }

    public void setAutoRead(boolean enableAutoRead) {
        this.connection.setAutoRead(enableAutoRead);
    }

    @Override
    public void close() {
        logger.debug("Closing client");
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private static class ClientHandshakeHandler
    extends AbstractHandshakeHandler<HR> {
        private final CC connection;
        final /* synthetic */ BasicClient this$0;

        ClientHandshakeHandler(CC connection) {
            this.this$0 = var1_1;
            super(((BasicClient)var1_1).handshakeType, ((BasicClient)var1_1).handshakeParser);
            Preconditions.checkNotNull(connection);
            this.connection = connection;
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, HR msg) throws Exception {
            RpcOutcome response = this.connection.getAndRemoveRpcOutcome(this.handshakeType.getNumber(), this.coordinationId, this.this$0.responseClass);
            response.set(msg, null);
        }
    }

    private class IdlePingHandler
    extends IdleStateHandler {
        private GenericFutureListener<Future<? super Void>> pingFailedHandler;

        IdlePingHandler(long idleWaitInMillis) {
            super(0L, idleWaitInMillis, 0L, TimeUnit.MILLISECONDS);
            this.pingFailedHandler = new GenericFutureListener<Future<? super Void>>(){

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        logger.error("Unable to maintain connection {}.  Closing connection.", (Object)BasicClient.this.connection.getName());
                        BasicClient.this.connection.close();
                    }
                }
            };
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush(PING_MESSAGE).addListener((GenericFutureListener<? extends Future<? super Void>>)this.pingFailedHandler);
            }
        }
    }
}

