/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.commons.lang3.ArrayUtils;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.FieldIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(HyperVectorWrapper.class);
    private T[] vectors;
    private MaterializedField f;
    private final boolean releasable;

    public HyperVectorWrapper(MaterializedField f, T[] v) {
        this(f, (ValueVector[])v, true);
    }

    public HyperVectorWrapper(MaterializedField f, T[] v, boolean releasable) {
        assert (v.length > 0);
        this.f = f;
        this.vectors = v;
        this.releasable = releasable;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.vectors.getClass().getComponentType();
    }

    @Override
    public MaterializedField getField() {
        return this.f;
    }

    @Override
    public T getValueVector() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T[] getValueVectors() {
        return this.vectors;
    }

    @Override
    public boolean isHyper() {
        return true;
    }

    @Override
    public void clear() {
        if (!this.releasable) {
            return;
        }
        for (T x : this.vectors) {
            x.clear();
        }
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        ValueVector[] vectors = new ValueVector[this.vectors.length];
        int index = 0;
        T[] TArray = this.vectors;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T v;
            Object vector = v = TArray[i];
            for (int i2 = 1; i2 < ids.length; ++i2) {
                AbstractMapVector mapLike = (AbstractMapVector)AbstractMapVector.class.cast(vector);
                if (mapLike == null) {
                    return null;
                }
                vector = mapLike.getChildByOrdinal(ids[i2]);
            }
            vectors[index] = vector;
            ++index;
        }
        return new HyperVectorWrapper(vectors[0].getField(), vectors);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, SchemaPath expectedPath) {
        T v = this.vectors[0];
        return FieldIdUtil.getFieldId(v, id, expectedPath, true);
    }

    @Override
    public VectorWrapper<T> cloneAndTransfer(BufferAllocator allocator) {
        return new HyperVectorWrapper(this.f, this.vectors, false);
    }

    public static <T extends ValueVector> HyperVectorWrapper<T> create(MaterializedField f, T[] v, boolean releasable) {
        return new HyperVectorWrapper(f, v, releasable);
    }

    public void addVector(ValueVector v) {
        Preconditions.checkArgument(v.getClass() == this.getVectorClass(), String.format("Cannot add vector type %s to hypervector type %s for field %s", v.getClass(), this.getVectorClass(), v.getField()));
        this.vectors = ArrayUtils.add(this.vectors, v);
    }

    public void addVectors(ValueVector[] vv) {
        this.vectors = (ValueVector[])ArrayUtils.add(this.vectors, vv);
    }

    @Override
    public void transfer(VectorWrapper<?> destination) {
        Preconditions.checkArgument(destination instanceof HyperVectorWrapper);
        Preconditions.checkArgument(this.getField().getType().equals(destination.getField().getType()));
        Preconditions.checkArgument(this.vectors.length == ((HyperVectorWrapper)destination).vectors.length);
        T[] destionationVectors = ((HyperVectorWrapper)destination).vectors;
        for (int i = 0; i < this.vectors.length; ++i) {
            this.vectors[i].makeTransferPair((ValueVector)destionationVectors[i]).transfer();
        }
    }
}

