/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.record.AbstractRecordBatch;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingleRecordBatch<T extends PhysicalOperator>
extends AbstractRecordBatch<T> {
    private static final Logger logger = LoggerFactory.getLogger(new Object(){}.getClass().getEnclosingClass());
    protected final RecordBatch incoming;
    protected boolean outOfMemory = false;
    protected SchemaChangeCallBack callBack = new SchemaChangeCallBack();

    public AbstractSingleRecordBatch(T popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context, false);
        this.incoming = incoming;
    }

    @Override
    protected void killIncoming(boolean sendUpstream) {
        this.incoming.kill(sendUpstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return RecordBatch.IterOutcome.NONE;
        }
        RecordBatch.IterOutcome upstream = this.next(this.incoming);
        if (this.state != AbstractRecordBatch.BatchState.FIRST && upstream == RecordBatch.IterOutcome.OK && this.incoming.getRecordCount() == 0) {
            do {
                for (VectorWrapper w : this.incoming) {
                    w.clear();
                }
            } while ((upstream = this.next(this.incoming)) == RecordBatch.IterOutcome.OK && this.incoming.getRecordCount() == 0);
        }
        if (this.state == AbstractRecordBatch.BatchState.FIRST && upstream == RecordBatch.IterOutcome.OK) {
            upstream = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        switch (upstream) {
            case NONE: {
                if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                    return this.handleNullInput();
                }
                return upstream;
            }
            case NOT_YET: 
            case STOP: {
                if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                    this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                }
                return upstream;
            }
            case OUT_OF_MEMORY: {
                return upstream;
            }
            case OK_NEW_SCHEMA: {
                if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                    this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
                }
                try {
                    this.stats.startSetup();
                    if (!this.setupNewSchema()) {
                        upstream = RecordBatch.IterOutcome.OK;
                    }
                }
                catch (SchemaChangeException ex) {
                    this.kill(false);
                    logger.error("Failure during query", ex);
                    this.context.fail(ex);
                    RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.STOP;
                    return iterOutcome;
                }
                finally {
                    this.stats.stopSetup();
                }
            }
            case OK: {
                assert (this.state != AbstractRecordBatch.BatchState.FIRST) : "First batch should be OK_NEW_SCHEMA";
                this.container.zeroVectors();
                RecordBatch.IterOutcome out = this.doWork();
                if (out != RecordBatch.IterOutcome.OK) {
                    upstream = out;
                }
                if (this.outOfMemory) {
                    this.outOfMemory = false;
                    return RecordBatch.IterOutcome.OUT_OF_MEMORY;
                }
                if (this.callBack.getSchemaChangedAndReset()) {
                    return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                }
                return upstream;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchSchema getSchema() {
        if (this.container.hasSchema()) {
            return this.container.getSchema();
        }
        return null;
    }

    protected abstract boolean setupNewSchema() throws SchemaChangeException;

    protected abstract RecordBatch.IterOutcome doWork();

    protected RecordBatch.IterOutcome handleNullInput() {
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        return RecordBatch.IterOutcome.NONE;
    }
}

