/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.holders;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;

public final class Decimal38DenseHolder
implements ValueHolder {
    public static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.DECIMAL38DENSE);
    public static final int WIDTH = 16;
    public int start;
    public DrillBuf buffer;
    public int scale;
    public int precision;
    public static final int maxPrecision = 38;
    public static final int nDecimalDigits = 4;

    public static int getInteger(int index, int start, DrillBuf buffer) {
        int value = buffer.getInt(start + index * 4);
        if (index == 0) {
            value &= 0x7F;
        }
        return value;
    }

    public static void setInteger(int index, int value, int start, DrillBuf buffer) {
        buffer.setInt(start + index * 4, value);
    }

    public static void setSign(boolean sign, int start, DrillBuf buffer) {
        if (sign) {
            int value = Decimal38DenseHolder.getInteger(0, start, buffer);
            Decimal38DenseHolder.setInteger(0, value | Integer.MIN_VALUE, start, buffer);
        }
    }

    public static boolean getSign(int start, DrillBuf buffer) {
        return (buffer.getInt(start) & Integer.MIN_VALUE) != 0;
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String toString() {
        throw new UnsupportedOperationException();
    }
}

