/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;

public enum BooleanType {
    TRUE(1, Arrays.asList("t", "true", "y", "yes", "on", "1")),
    FALSE(0, Arrays.asList("f", "false", "n", "no", "off", "0"));

    private final int numericValue;
    private final List<String> literals;
    private static final Map<String, BooleanType> allLiterals;

    private BooleanType(int numericValue, List<String> literals) {
        this.numericValue = numericValue;
        this.literals = literals;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public List<String> getLiterals() {
        return this.literals;
    }

    public static BooleanType get(String literal) {
        String value = literal.trim();
        BooleanType booleanType = allLiterals.get(value);
        if (booleanType == null) {
            throw new IllegalArgumentException("Invalid value for boolean: " + literal);
        }
        return booleanType;
    }

    static {
        allLiterals = CaseInsensitiveMap.newHashMap();
        for (BooleanType booleanType : BooleanType.values()) {
            for (String literal : booleanType.getLiterals()) {
                allLiterals.put(literal, booleanType);
            }
        }
    }
}

