/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.util.List;
import oadd.com.google.common.collect.ImmutableList;
import oadd.org.apache.curator.framework.api.ACLProvider;
import oadd.org.apache.zookeeper.ZooDefs;
import oadd.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKSecureACLProvider
implements ACLProvider {
    static final Logger logger = LoggerFactory.getLogger(ZKSecureACLProvider.class);
    static ImmutableList<ACL> DEFAULT_ACL = ((ImmutableList.Builder)new ImmutableList.Builder().addAll(ZooDefs.Ids.CREATOR_ALL_ACL.iterator())).build();
    static ImmutableList<ACL> DRILL_CLUSTER_ACL = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(ZooDefs.Ids.READ_ACL_UNSAFE.iterator())).addAll(ZooDefs.Ids.CREATOR_ALL_ACL.iterator())).build();
    final String drillClusterPath;

    public ZKSecureACLProvider(String drillClusterPath) {
        this.drillClusterPath = drillClusterPath;
    }

    @Override
    public List<ACL> getDefaultAcl() {
        return DEFAULT_ACL;
    }

    @Override
    public List<ACL> getAclForPath(String path) {
        logger.trace("getAclForPath " + path);
        if (path.startsWith(this.drillClusterPath)) {
            logger.trace("getAclForPath drillClusterPath " + path);
            return DRILL_CLUSTER_ACL;
        }
        return DEFAULT_ACL;
    }
}

