/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import oadd.org.apache.curator.framework.api.ACLProvider;
import oadd.org.apache.curator.framework.imps.DefaultACLProvider;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.coord.zk.ZKSecureACLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKACLProviderFactory {
    static final Logger logger = LoggerFactory.getLogger(ZKACLProviderFactory.class);

    public static ACLProvider getACLProvider(DrillConfig config, String drillClusterPath) {
        if (config.getBoolean("drill.exec.zk.apply_secure_acl")) {
            logger.trace("Using secure ZK ACL. Drill cluster path " + drillClusterPath);
            return new ZKSecureACLProvider(drillClusterPath);
        }
        logger.trace("Using un-secure default ZK ACL");
        return new DefaultACLProvider();
    }
}

