/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.store;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Iterators;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.exec.coord.store.TransientStore;
import oadd.org.apache.drill.exec.coord.store.TransientStoreConfig;
import oadd.org.apache.drill.exec.coord.store.TransientStoreEvent;
import oadd.org.apache.drill.exec.coord.store.TransientStoreListener;

public abstract class BaseTransientStore<V>
implements TransientStore<V> {
    private final Set<TransientStoreListener> listeners = Collections.newSetFromMap(Maps.newConcurrentMap());
    protected final TransientStoreConfig<V> config;

    protected BaseTransientStore(TransientStoreConfig<V> config) {
        this.config = Preconditions.checkNotNull(config, "config cannot be null");
    }

    public TransientStoreConfig<V> getConfig() {
        return this.config;
    }

    @Override
    public Iterator<String> keys() {
        return Iterators.transform(this.entries(), new Function<Map.Entry<String, V>, String>(){

            @Override
            @Nullable
            public String apply(@Nullable Map.Entry<String, V> input) {
                return input.getKey();
            }
        });
    }

    @Override
    public Iterator<V> values() {
        return Iterators.transform(this.entries(), new Function<Map.Entry<String, V>, V>(){

            @Override
            @Nullable
            public V apply(Map.Entry<String, V> entry) {
                return entry.getValue();
            }
        });
    }

    protected void fireListeners(TransientStoreEvent event) {
        for (TransientStoreListener listener : this.listeners) {
            listener.onChange(event);
        }
    }

    @Override
    public void addListener(TransientStoreListener listener) {
        this.listeners.add(Preconditions.checkNotNull(listener, "listener cannot be null"));
    }

    @Override
    public void removeListener(TransientStoreListener listener) {
        this.listeners.remove(Preconditions.checkNotNull(listener, "listener cannot be null"));
    }
}

