/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.node.ArrayNode;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.util.concurrent.SettableFuture;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.DrillAutoCloseables;
import oadd.org.apache.drill.common.Version;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.client.InvalidConnectionInfoException;
import oadd.org.apache.drill.exec.client.ServerMethod;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.ChannelClosedException;
import oadd.org.apache.drill.exec.rpc.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.NamedThreadFactory;
import oadd.org.apache.drill.exec.rpc.NonTransientRpcException;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserClient;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import oadd.org.apache.drill.exec.rpc.user.UserRpcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillClient
implements Closeable,
ConnectionThrottle {
    public static final String DEFAULT_CLIENT_NAME = "Apache Drill Java client";
    private static final Logger logger = LoggerFactory.getLogger(DrillClient.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final DrillConfig config;
    private UserClient client;
    private DrillProperties properties;
    private volatile ClusterCoordinator clusterCoordinator;
    private volatile boolean connected = false;
    private final BufferAllocator allocator;
    private int reconnectTimes;
    private int reconnectDelay;
    private boolean supportComplexTypes;
    private final boolean ownsZkConnection;
    private final boolean ownsAllocator;
    private final boolean isDirectConnection;
    private EventLoopGroup eventLoopGroup;
    private ExecutorService executor;
    private String clientName = "Apache Drill Java client";

    public DrillClient() throws OutOfMemoryException {
        this(DrillConfig.create(), false);
    }

    public DrillClient(boolean isDirect) throws OutOfMemoryException {
        this(DrillConfig.create(), isDirect);
    }

    public DrillClient(String fileName) throws OutOfMemoryException {
        this(DrillConfig.create(fileName), false);
    }

    public DrillClient(DrillConfig config) throws OutOfMemoryException {
        this(config, null, false);
    }

    public DrillClient(DrillConfig config, boolean isDirect) throws OutOfMemoryException {
        this(config, null, isDirect);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator) throws OutOfMemoryException {
        this(config, coordinator, null, false);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, boolean isDirect) throws OutOfMemoryException {
        this(config, coordinator, null, isDirect);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, BufferAllocator allocator) throws OutOfMemoryException {
        this(config, coordinator, allocator, false);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, BufferAllocator allocator, boolean isDirect) {
        this.isDirectConnection = isDirect;
        this.ownsZkConnection = coordinator == null && !isDirect;
        this.ownsAllocator = allocator == null;
        this.allocator = this.ownsAllocator ? RootAllocatorFactory.newRoot(config) : allocator;
        this.config = config;
        this.clusterCoordinator = coordinator;
        this.reconnectTimes = config.getInt("drill.exec.rpc.bit.server.retry.count");
        this.reconnectDelay = config.getInt("drill.exec.rpc.bit.server.retry.delay");
        this.supportComplexTypes = config.getBoolean("drill.client.supports-complex-types");
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.client.setAutoRead(enableAutoRead);
    }

    public void setClientName(String name) {
        if (this.connected) {
            throw new IllegalStateException("Attempted to modify client connection property after connection has been established.");
        }
        this.clientName = Preconditions.checkNotNull(name, "client name should not be null");
    }

    public void setSupportComplexTypes(boolean supportComplexTypes) {
        if (this.connected) {
            throw new IllegalStateException("Attempted to modify client connection property after connection has been established.");
        }
        this.supportComplexTypes = supportComplexTypes;
    }

    public void connect() throws RpcException {
        this.connect(null, null);
    }

    public void connect(Properties props) throws RpcException {
        this.connect(null, props);
    }

    static List<CoordinationProtos.DrillbitEndpoint> parseAndVerifyEndpoints(String drillbits, String defaultUserPort) throws InvalidConnectionInfoException {
        String[] connectInfo;
        if ((drillbits = drillbits.trim()).isEmpty()) {
            throw new InvalidConnectionInfoException("No drillbit information specified in the connection string");
        }
        ArrayList<CoordinationProtos.DrillbitEndpoint> endpointList = new ArrayList<CoordinationProtos.DrillbitEndpoint>();
        for (String drillbit : connectInfo = drillbits.split(",")) {
            if ((drillbit = drillbit.trim()).isEmpty()) continue;
            if (drillbit.charAt(0) == ':') {
                throw new InvalidConnectionInfoException("Malformed connection string with drillbit hostname or hostaddress missing for an entry: " + drillbit);
            }
            String[] drillbitInfo = drillbit.split(":");
            if (drillbitInfo.length > 2) {
                throw new InvalidConnectionInfoException("Malformed connection string with more than one port in a drillbit entry: " + drillbit);
            }
            String ipAddress = drillbitInfo[0].trim();
            String port = defaultUserPort;
            if (drillbitInfo.length == 2) {
                port = drillbitInfo[1].trim();
            }
            try {
                CoordinationProtos.DrillbitEndpoint endpoint = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(ipAddress).setUserPort(Integer.parseInt(port)).build();
                endpointList.add(endpoint);
            }
            catch (NumberFormatException e) {
                throw new InvalidConnectionInfoException("Malformed port value in entry: " + ipAddress + ":" + port + " passed in connection string");
            }
        }
        if (endpointList.size() == 0) {
            throw new InvalidConnectionInfoException("No valid drillbit information specified in the connection string");
        }
        return endpointList;
    }

    public synchronized void connect(String connect, Properties props) throws RpcException {
        int connectTriesVal;
        if (this.connected) {
            return;
        }
        this.properties = DrillProperties.createFromProperties(props);
        ArrayList<CoordinationProtos.DrillbitEndpoint> endpoints = new ArrayList<CoordinationProtos.DrillbitEndpoint>();
        if (this.isDirectConnection) {
            endpoints.addAll(DrillClient.parseAndVerifyEndpoints(this.properties.getProperty("drillbit"), this.config.getString("drill.exec.rpc.user.server.port")));
        } else {
            if (this.ownsZkConnection) {
                try {
                    this.clusterCoordinator = new ZKClusterCoordinator(this.config, connect);
                    this.clusterCoordinator.start(10000L);
                }
                catch (Exception e) {
                    throw new RpcException("Failure setting up ZK for client.", e);
                }
            }
            endpoints.addAll(this.clusterCoordinator.getOnlineEndPoints());
            Preconditions.checkState(!endpoints.isEmpty(), "No active Drillbit endpoint found from ZooKeeper. Check connection parameters?");
        }
        Collections.shuffle(endpoints);
        this.eventLoopGroup = DrillClient.createEventLoop(this.config.getInt("drill.exec.rpc.user.client.threads"), "Client-");
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new NamedThreadFactory("drill-client-executor-")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t);
                }
                super.afterExecute(r, t);
            }
        };
        String connectTriesConf = this.properties.getProperty("tries", "5");
        try {
            connectTriesVal = Math.min(endpoints.size(), Integer.parseInt(connectTriesConf));
        }
        catch (NumberFormatException e) {
            throw new InvalidConnectionInfoException("Invalid tries value: " + connectTriesConf + " specified in connection string");
        }
        connectTriesVal = Math.max(1, connectTriesVal);
        int triedEndpointIndex = 0;
        while (triedEndpointIndex < connectTriesVal) {
            CoordinationProtos.DrillbitEndpoint endpoint = (CoordinationProtos.DrillbitEndpoint)endpoints.get(triedEndpointIndex);
            this.client = new UserClient(this.clientName, this.config, props, this.supportComplexTypes, this.allocator, this.eventLoopGroup, this.executor, endpoint);
            logger.debug("Connecting to server {}:{}", (Object)endpoint.getAddress(), (Object)endpoint.getUserPort());
            if (!this.properties.containsKey("service_host")) {
                this.properties.setProperty("service_host", endpoint.getAddress());
            }
            try {
                this.connect(endpoint);
                this.connected = true;
                logger.info("Successfully connected to server {}:{}", (Object)endpoint.getAddress(), (Object)endpoint.getUserPort());
                break;
            }
            catch (NonTransientRpcException ex) {
                logger.error("Connection to {}:{} failed with error {}. Not retrying anymore", endpoint.getAddress(), endpoint.getUserPort(), ex.getMessage());
                throw ex;
            }
            catch (RpcException ex) {
                logger.error("Attempt {}: Failed to connect to server {}:{}", ++triedEndpointIndex, endpoint.getAddress(), endpoint.getUserPort());
                if (triedEndpointIndex == connectTriesVal) {
                    throw ex;
                }
                this.client.close();
            }
        }
    }

    protected static EventLoopGroup createEventLoop(int size, String prefix) {
        return TransportCheck.createEventLoopGroup(size, prefix);
    }

    public synchronized boolean reconnect() {
        if (this.client.isActive()) {
            return true;
        }
        for (int retry = this.reconnectTimes; retry > 0; --retry) {
            try {
                Thread.sleep(this.reconnectDelay);
                ArrayList<CoordinationProtos.DrillbitEndpoint> endpoints = new ArrayList<CoordinationProtos.DrillbitEndpoint>(this.clusterCoordinator.getOnlineEndPoints());
                if (endpoints.isEmpty()) continue;
                this.client.close();
                Collections.shuffle(endpoints);
                this.connect(endpoints.iterator().next());
                return true;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return false;
    }

    private void connect(CoordinationProtos.DrillbitEndpoint endpoint) throws RpcException {
        this.client.connect(endpoint, this.properties, this.getUserCredentials());
        logger.info("Foreman drillbit is {}", (Object)endpoint.getAddress());
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.ownsAllocator && this.allocator != null) {
            DrillAutoCloseables.closeNoChecked(this.allocator);
        }
        if (this.ownsZkConnection && this.clusterCoordinator != null) {
            try {
                this.clusterCoordinator.close();
                this.clusterCoordinator = null;
            }
            catch (Exception e) {
                logger.warn("Error while closing Cluster Coordinator.", e);
            }
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.connected = false;
    }

    @Deprecated
    public UserProtos.RpcEndpointInfos getServerInfos() {
        return this.client != null ? this.client.getServerInfos() : null;
    }

    public String getServerName() {
        return this.client != null && this.client.getServerInfos() != null ? this.client.getServerInfos().getName() : null;
    }

    public Version getServerVersion() {
        return this.client != null && this.client.getServerInfos() != null ? UserRpcUtils.getVersion(this.client.getServerInfos()) : null;
    }

    public DrillRpcFuture<UserProtos.GetServerMetaResp> getServerMeta() {
        return this.client.send(UserProtos.RpcType.GET_SERVER_META, UserProtos.GetServerMetaReq.getDefaultInstance(), UserProtos.GetServerMetaResp.class, new ByteBuf[0]);
    }

    public Set<ServerMethod> getSupportedMethods() {
        return this.client != null ? ServerMethod.getSupportedMethods(this.client.getSupportedMethods(), this.client.getServerInfos()) : null;
    }

    public List<QueryDataBatch> runQuery(UserBitShared.QueryType type, String plan) throws RpcException {
        Preconditions.checkArgument(type == UserBitShared.QueryType.LOGICAL || type == UserBitShared.QueryType.PHYSICAL || type == UserBitShared.QueryType.SQL, String.format("Only query types %s, %s and %s are supported in this API", UserBitShared.QueryType.LOGICAL, UserBitShared.QueryType.PHYSICAL, UserBitShared.QueryType.SQL));
        UserProtos.RunQuery query = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build();
        ListHoldingResultsListener listener = new ListHoldingResultsListener(query);
        this.client.submitQuery(listener, query);
        return listener.getResults();
    }

    public DrillRpcFuture<UserProtos.QueryPlanFragments> planQuery(UserBitShared.QueryType type, String query, boolean isSplitPlan) {
        UserProtos.GetQueryPlanFragments runQuery = UserProtos.GetQueryPlanFragments.newBuilder().setQuery(query).setType(type).setSplitPlan(isSplitPlan).build();
        return this.client.planQuery(runQuery);
    }

    public void runQuery(UserBitShared.QueryType type, List<BitControl.PlanFragment> planFragments, UserResultsListener resultsListener) throws RpcException {
        String fragmentsToJsonString;
        Preconditions.checkArgument(UserBitShared.QueryType.EXECUTION == type, "Only EXECUTION type query is supported with PlanFragments");
        ArrayNode jsonArray = objectMapper.createArrayNode();
        for (BitControl.PlanFragment fragment : planFragments) {
            try {
                jsonArray.add(objectMapper.readTree(fragment.getFragmentJson()));
            }
            catch (IOException e) {
                logger.error("Exception while trying to read PlanFragment JSON for %s", (Object)fragment.getHandle().getQueryId(), (Object)e);
                throw new RpcException(e);
            }
        }
        try {
            fragmentsToJsonString = objectMapper.writeValueAsString(jsonArray);
        }
        catch (JsonProcessingException e) {
            logger.error("Exception while trying to get JSONString from Array of individual Fragments Json for %s", e);
            throw new RpcException(e);
        }
        UserProtos.RunQuery query = UserProtos.RunQuery.newBuilder().setType(type).addAllFragments(planFragments).setPlan(fragmentsToJsonString).setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).build();
        this.client.submitQuery(resultsListener, query);
    }

    private UserBitShared.UserCredentials getUserCredentials() {
        String userName = this.properties.getProperty("user");
        if (Strings.isNullOrEmpty(userName)) {
            userName = "anonymous";
        }
        return UserBitShared.UserCredentials.newBuilder().setUserName(userName).build();
    }

    public DrillRpcFuture<GeneralRPCProtos.Ack> cancelQuery(UserBitShared.QueryId id) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling query {}", (Object)QueryIdHelper.getQueryId(id));
        }
        return this.client.send(UserProtos.RpcType.CANCEL_QUERY, id, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<GeneralRPCProtos.Ack> resumeQuery(UserBitShared.QueryId queryId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Resuming query {}", (Object)QueryIdHelper.getQueryId(queryId));
        }
        return this.client.send(UserProtos.RpcType.RESUME_PAUSED_QUERY, queryId, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<UserProtos.GetCatalogsResp> getCatalogs(UserProtos.LikeFilter catalogNameFilter) {
        UserProtos.GetCatalogsReq.Builder reqBuilder = UserProtos.GetCatalogsReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_CATALOGS, reqBuilder.build(), UserProtos.GetCatalogsResp.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<UserProtos.GetSchemasResp> getSchemas(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter) {
        UserProtos.GetSchemasReq.Builder reqBuilder = UserProtos.GetSchemasReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        if (schemaNameFilter != null) {
            reqBuilder.setSchemaNameFilter(schemaNameFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_SCHEMAS, reqBuilder.build(), UserProtos.GetSchemasResp.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<UserProtos.GetTablesResp> getTables(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter, UserProtos.LikeFilter tableNameFilter, List<String> tableTypeFilter) {
        UserProtos.GetTablesReq.Builder reqBuilder = UserProtos.GetTablesReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        if (schemaNameFilter != null) {
            reqBuilder.setSchemaNameFilter(schemaNameFilter);
        }
        if (tableNameFilter != null) {
            reqBuilder.setTableNameFilter(tableNameFilter);
        }
        if (tableTypeFilter != null) {
            reqBuilder.addAllTableTypeFilter(tableTypeFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_TABLES, reqBuilder.build(), UserProtos.GetTablesResp.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<UserProtos.GetColumnsResp> getColumns(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter, UserProtos.LikeFilter tableNameFilter, UserProtos.LikeFilter columnNameFilter) {
        UserProtos.GetColumnsReq.Builder reqBuilder = UserProtos.GetColumnsReq.newBuilder();
        if (catalogNameFilter != null) {
            reqBuilder.setCatalogNameFilter(catalogNameFilter);
        }
        if (schemaNameFilter != null) {
            reqBuilder.setSchemaNameFilter(schemaNameFilter);
        }
        if (tableNameFilter != null) {
            reqBuilder.setTableNameFilter(tableNameFilter);
        }
        if (columnNameFilter != null) {
            reqBuilder.setColumnNameFilter(columnNameFilter);
        }
        return this.client.send(UserProtos.RpcType.GET_COLUMNS, reqBuilder.build(), UserProtos.GetColumnsResp.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<UserProtos.CreatePreparedStatementResp> createPreparedStatement(String query) {
        UserProtos.CreatePreparedStatementReq req = UserProtos.CreatePreparedStatementReq.newBuilder().setSqlQuery(query).build();
        return this.client.send(UserProtos.RpcType.CREATE_PREPARED_STATEMENT, req, UserProtos.CreatePreparedStatementResp.class, new ByteBuf[0]);
    }

    public void executePreparedStatement(UserProtos.PreparedStatementHandle preparedStatementHandle, UserResultsListener resultsListener) {
        UserProtos.RunQuery runQuery = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(UserBitShared.QueryType.PREPARED_STATEMENT).setPreparedStatementHandle(preparedStatementHandle).build();
        this.client.submitQuery(resultsListener, runQuery);
    }

    @VisibleForTesting
    public List<QueryDataBatch> executePreparedStatement(UserProtos.PreparedStatementHandle preparedStatementHandle) throws RpcException {
        UserProtos.RunQuery runQuery = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(UserBitShared.QueryType.PREPARED_STATEMENT).setPreparedStatementHandle(preparedStatementHandle).build();
        ListHoldingResultsListener resultsListener = new ListHoldingResultsListener(runQuery);
        this.client.submitQuery(resultsListener, runQuery);
        return resultsListener.getResults();
    }

    public void runQuery(UserBitShared.QueryType type, String plan, UserResultsListener resultsListener) {
        this.client.submitQuery(resultsListener, UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build());
    }

    private class ListHoldingResultsListener
    implements UserResultsListener {
        private final Vector<QueryDataBatch> results = new Vector();
        private final SettableFuture<List<QueryDataBatch>> future = SettableFuture.create();
        private final UserProtos.RunQuery query;

        public ListHoldingResultsListener(UserProtos.RunQuery query) {
            logger.debug("Listener created for query \"\"\"{}\"\"\"", (Object)query);
            this.query = query;
        }

        @Override
        public void submissionFailed(UserException ex) {
            if (ex.getCause() instanceof ChannelClosedException) {
                if (DrillClient.this.reconnect()) {
                    try {
                        DrillClient.this.client.submitQuery(this, this.query);
                    }
                    catch (Exception e) {
                        this.fail(e);
                    }
                } else {
                    this.fail(ex);
                }
            } else {
                this.fail(ex);
            }
        }

        @Override
        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            this.future.set(this.results);
        }

        private void fail(Exception ex) {
            logger.debug("Submission failed.", ex);
            this.future.setException(ex);
            this.future.set(this.results);
        }

        @Override
        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            logger.debug("Result arrived:  Result: {}", (Object)result);
            this.results.add(result);
        }

        public List<QueryDataBatch> getResults() throws RpcException {
            try {
                return (List)this.future.get();
            }
            catch (Throwable t) {
                for (QueryDataBatch queryDataBatch : this.results) {
                    queryDataBatch.release();
                }
                throw RpcException.mapException(t);
            }
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
            if (logger.isDebugEnabled()) {
                logger.debug("Query ID arrived: {}", (Object)QueryIdHelper.getQueryId(queryId));
            }
        }
    }
}

