/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.x.discovery.details;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.listen.ListenerContainer;
import oadd.org.apache.curator.framework.recipes.cache.ChildData;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import oadd.org.apache.curator.utils.CloseableUtils;
import oadd.org.apache.curator.utils.ZKPaths;
import oadd.org.apache.curator.x.discovery.ServiceCache;
import oadd.org.apache.curator.x.discovery.ServiceInstance;
import oadd.org.apache.curator.x.discovery.details.ServiceCacheListener;
import oadd.org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceCacheImpl<T>
implements ServiceCache<T>,
PathChildrenCacheListener {
    private final ListenerContainer<ServiceCacheListener> listenerContainer = new ListenerContainer();
    private final ServiceDiscoveryImpl<T> discovery;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final PathChildrenCache cache;
    private final ConcurrentMap<String, ServiceInstance<T>> instances = Maps.newConcurrentMap();

    ServiceCacheImpl(ServiceDiscoveryImpl<T> discovery, String name, ThreadFactory threadFactory) {
        Preconditions.checkNotNull(discovery, "discovery cannot be null");
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(threadFactory, "threadFactory cannot be null");
        this.discovery = discovery;
        this.cache = new PathChildrenCache(discovery.getClient(), discovery.pathForName(name), true, threadFactory);
        this.cache.getListenable().addListener(this);
    }

    @Override
    public List<ServiceInstance<T>> getInstances() {
        return Lists.newArrayList(this.instances.values());
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.cache.start(true);
        for (ChildData childData : this.cache.getCurrentData()) {
            this.addInstance(childData, true);
        }
        this.discovery.cacheOpened(this);
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState(this.state.compareAndSet(State.STARTED, State.STOPPED), "Already closed or has not been started");
        this.listenerContainer.forEach(new Function<ServiceCacheListener, Void>(){

            @Override
            public Void apply(ServiceCacheListener listener) {
                ServiceCacheImpl.this.discovery.getClient().getConnectionStateListenable().removeListener(listener);
                return null;
            }
        });
        this.listenerContainer.clear();
        CloseableUtils.closeQuietly(this.cache);
        this.discovery.cacheClosed(this);
    }

    @Override
    public void addListener(ServiceCacheListener listener) {
        this.listenerContainer.addListener(listener);
        this.discovery.getClient().getConnectionStateListenable().addListener(listener);
    }

    @Override
    public void addListener(ServiceCacheListener listener, Executor executor) {
        this.listenerContainer.addListener(listener, executor);
        this.discovery.getClient().getConnectionStateListenable().addListener(listener, executor);
    }

    @Override
    public void removeListener(ServiceCacheListener listener) {
        this.listenerContainer.removeListener(listener);
        this.discovery.getClient().getConnectionStateListenable().removeListener(listener);
    }

    @Override
    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        boolean notifyListeners = false;
        switch (event.getType()) {
            case CHILD_ADDED: 
            case CHILD_UPDATED: {
                this.addInstance(event.getData(), false);
                notifyListeners = true;
                break;
            }
            case CHILD_REMOVED: {
                this.instances.remove(this.instanceIdFromData(event.getData()));
                notifyListeners = true;
            }
        }
        if (notifyListeners) {
            this.listenerContainer.forEach(new Function<ServiceCacheListener, Void>(){

                @Override
                public Void apply(ServiceCacheListener listener) {
                    listener.cacheChanged();
                    return null;
                }
            });
        }
    }

    private String instanceIdFromData(ChildData childData) {
        return ZKPaths.getNodeFromPath(childData.getPath());
    }

    private void addInstance(ChildData childData, boolean onlyIfAbsent) throws Exception {
        String instanceId = this.instanceIdFromData(childData);
        ServiceInstance<T> serviceInstance = this.discovery.getSerializer().deserialize(childData.getData());
        if (onlyIfAbsent) {
            this.instances.putIfAbsent(instanceId, serviceInstance);
        } else {
            this.instances.put(instanceId, serviceInstance);
        }
        this.cache.clearDataBytes(childData.getPath(), childData.getStat().getVersion());
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

