/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.httpclient.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oadd.org.apache.commons.httpclient.HttpConnection;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;

public class IdleConnectionHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$util$IdleConnectionHandler == null ? (class$org$apache$commons$httpclient$util$IdleConnectionHandler = IdleConnectionHandler.class$("oadd.org.apache.commons.httpclient.util.IdleConnectionHandler")) : class$org$apache$commons$httpclient$util$IdleConnectionHandler));
    private Map connectionToAdded = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$httpclient$util$IdleConnectionHandler;

    public void add(HttpConnection connection) {
        Long timeAdded = new Long(System.currentTimeMillis());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding connection at: " + timeAdded));
        }
        this.connectionToAdded.put(connection, timeAdded);
    }

    public void remove(HttpConnection connection) {
        this.connectionToAdded.remove(connection);
    }

    public void removeAll() {
        this.connectionToAdded.clear();
    }

    public void closeIdleConnections(long idleTime) {
        long idleTimeout = System.currentTimeMillis() - idleTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for connections, idleTimeout: " + idleTimeout));
        }
        Iterator connectionIter = this.connectionToAdded.keySet().iterator();
        while (connectionIter.hasNext()) {
            HttpConnection conn = (HttpConnection)connectionIter.next();
            Long connectionTime = (Long)this.connectionToAdded.get(conn);
            if (connectionTime > idleTimeout) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing connection, connection time: " + connectionTime));
            }
            connectionIter.remove();
            conn.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

