/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import oadd.org.apache.commons.collections.iterators.SingletonIterator;
import oadd.org.apache.commons.collections.set.ListOrderedSet;
import oadd.org.apache.commons.configuration.AbstractConfiguration;
import oadd.org.apache.commons.configuration.Configuration;
import oadd.org.apache.commons.configuration.ConfigurationKey;
import oadd.org.apache.commons.configuration.ConfigurationRuntimeException;
import oadd.org.apache.commons.configuration.PropertyConverter;
import oadd.org.apache.commons.configuration.SubnodeConfiguration;
import oadd.org.apache.commons.configuration.event.ConfigurationEvent;
import oadd.org.apache.commons.configuration.event.ConfigurationListener;
import oadd.org.apache.commons.configuration.tree.ConfigurationNode;
import oadd.org.apache.commons.configuration.tree.ConfigurationNodeVisitorAdapter;
import oadd.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import oadd.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import oadd.org.apache.commons.configuration.tree.ExpressionEngine;
import oadd.org.apache.commons.configuration.tree.NodeAddData;
import oadd.org.apache.commons.lang.StringUtils;

public class HierarchicalConfiguration
extends AbstractConfiguration
implements Serializable,
Cloneable {
    public static final int EVENT_CLEAR_TREE = 10;
    public static final int EVENT_ADD_NODES = 11;
    public static final int EVENT_SUBNODE_CHANGED = 12;
    private static final long serialVersionUID = 3373812230395363192L;
    private static ExpressionEngine defaultExpressionEngine;
    private Node root;
    private ConfigurationNode rootNode;
    private transient ExpressionEngine expressionEngine;

    public HierarchicalConfiguration() {
        this.setRootNode(new Node());
    }

    public HierarchicalConfiguration(HierarchicalConfiguration c) {
        this();
        if (c != null) {
            CloneVisitor visitor = new CloneVisitor();
            c.getRootNode().visit(visitor);
            this.setRootNode(visitor.getClone());
        }
    }

    public Node getRoot() {
        if (this.root == null && this.rootNode != null) {
            return new Node(this.rootNode);
        }
        return this.root;
    }

    public void setRoot(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.root = node;
        this.rootNode = null;
    }

    public ConfigurationNode getRootNode() {
        return this.rootNode != null ? this.rootNode : this.root;
    }

    public void setRootNode(ConfigurationNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.rootNode = rootNode;
        this.root = rootNode instanceof Node ? (Node)rootNode : null;
    }

    public static synchronized ExpressionEngine getDefaultExpressionEngine() {
        if (defaultExpressionEngine == null) {
            defaultExpressionEngine = new DefaultExpressionEngine();
        }
        return defaultExpressionEngine;
    }

    public static synchronized void setDefaultExpressionEngine(ExpressionEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Default expression engine must not be null!");
        }
        defaultExpressionEngine = engine;
    }

    public ExpressionEngine getExpressionEngine() {
        return this.expressionEngine != null ? this.expressionEngine : HierarchicalConfiguration.getDefaultExpressionEngine();
    }

    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        this.expressionEngine = expressionEngine;
    }

    public Object getProperty(String key) {
        List nodes = this.fetchNodeList(key);
        if (nodes.size() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ConfigurationNode node = (ConfigurationNode)it.next();
            if (node.getValue() == null) continue;
            list.add(node.getValue());
        }
        if (list.size() < 1) {
            return null;
        }
        return list.size() == 1 ? list.get(0) : list;
    }

    protected void addPropertyDirect(String key, Object obj) {
        NodeAddData data = this.getExpressionEngine().prepareAdd(this.getRootNode(), key);
        ConfigurationNode node = this.processNodeAddData(data);
        node.setValue(obj);
    }

    public void addNodes(String key, Collection nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        this.fireEvent(11, key, nodes, true);
        List target = this.fetchNodeList(key);
        ConfigurationNode parent = target.size() == 1 ? (ConfigurationNode)target.get(0) : this.processNodeAddData(this.getExpressionEngine().prepareAdd(this.getRootNode(), key));
        if (parent.isAttribute()) {
            throw new IllegalArgumentException("Cannot add nodes to an attribute node!");
        }
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ConfigurationNode child = (ConfigurationNode)it.next();
            if (child.isAttribute()) {
                parent.addAttribute(child);
            } else {
                parent.addChild(child);
            }
            HierarchicalConfiguration.clearReferences(child);
        }
        this.fireEvent(11, key, nodes, false);
    }

    public boolean isEmpty() {
        return !this.nodeDefined(this.getRootNode());
    }

    public Configuration subset(String prefix) {
        List nodes = this.fetchNodeList(prefix);
        if (nodes.isEmpty()) {
            return new HierarchicalConfiguration();
        }
        final HierarchicalConfiguration parent = this;
        HierarchicalConfiguration result = new HierarchicalConfiguration(){

            protected Object interpolate(Object value) {
                return parent.interpolate(value);
            }
        };
        CloneVisitor visitor = new CloneVisitor();
        Object value = null;
        int valueCount = 0;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ConfigurationNode nd = (ConfigurationNode)it.next();
            if (nd.getValue() != null) {
                value = nd.getValue();
                ++valueCount;
            }
            nd.visit(visitor);
            Iterator it2 = visitor.getClone().getChildren().iterator();
            while (it2.hasNext()) {
                result.getRootNode().addChild((ConfigurationNode)it2.next());
            }
            it2 = visitor.getClone().getAttributes().iterator();
            while (it2.hasNext()) {
                result.getRootNode().addAttribute((ConfigurationNode)it2.next());
            }
        }
        if (valueCount == 1) {
            result.getRootNode().setValue(value);
        }
        return result.isEmpty() ? new HierarchicalConfiguration() : result;
    }

    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        List nodes = this.fetchNodeList(key);
        if (nodes.size() != 1) {
            throw new IllegalArgumentException("Passed in key must select exactly one node: " + key);
        }
        return supportUpdates ? this.createSubnodeConfiguration((ConfigurationNode)nodes.get(0), key) : this.createSubnodeConfiguration((ConfigurationNode)nodes.get(0));
    }

    public SubnodeConfiguration configurationAt(String key) {
        return this.configurationAt(key, false);
    }

    public List configurationsAt(String key) {
        List nodes = this.fetchNodeList(key);
        ArrayList<SubnodeConfiguration> configs = new ArrayList<SubnodeConfiguration>(nodes.size());
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            configs.add(this.createSubnodeConfiguration((ConfigurationNode)it.next()));
        }
        return configs;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node) {
        SubnodeConfiguration result = new SubnodeConfiguration(this, node);
        this.registerSubnodeConfiguration(result);
        return result;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node, String subnodeKey) {
        SubnodeConfiguration result = this.createSubnodeConfiguration(node);
        result.setSubnodeKey(subnodeKey);
        return result;
    }

    protected void subnodeConfigurationChanged(ConfigurationEvent event) {
        this.fireEvent(12, null, event, event.isBeforeUpdate());
    }

    void registerSubnodeConfiguration(SubnodeConfiguration config) {
        config.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                HierarchicalConfiguration.this.subnodeConfigurationChanged(event);
            }
        });
    }

    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    public void setProperty(String key, Object value) {
        this.fireEvent(3, key, value, true);
        Iterator itNodes = this.fetchNodeList(key).iterator();
        Iterator itValues = !this.isDelimiterParsingDisabled() ? PropertyConverter.toIterator(value, this.getListDelimiter()) : new SingletonIterator(value);
        while (itNodes.hasNext() && itValues.hasNext()) {
            ((ConfigurationNode)itNodes.next()).setValue(itValues.next());
        }
        while (itValues.hasNext()) {
            this.addPropertyDirect(key, itValues.next());
        }
        while (itNodes.hasNext()) {
            this.clearNode((ConfigurationNode)itNodes.next());
        }
        this.fireEvent(3, key, value, false);
    }

    public void clearTree(String key) {
        this.fireEvent(10, key, null, true);
        List nodes = this.fetchNodeList(key);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.removeNode((ConfigurationNode)it.next());
        }
        this.fireEvent(10, key, nodes, false);
    }

    public void clearProperty(String key) {
        this.fireEvent(2, key, null, true);
        List nodes = this.fetchNodeList(key);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.clearNode((ConfigurationNode)it.next());
        }
        this.fireEvent(2, key, null, false);
    }

    public Iterator getKeys() {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor();
        this.getRootNode().visit(visitor);
        return visitor.getKeyList().iterator();
    }

    public Iterator getKeys(String prefix) {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor(prefix);
        if (this.containsKey(prefix)) {
            visitor.getKeyList().add(prefix);
        }
        List nodes = this.fetchNodeList(prefix);
        Iterator itNodes = nodes.iterator();
        while (itNodes.hasNext()) {
            ConfigurationNode node = (ConfigurationNode)itNodes.next();
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                ((ConfigurationNode)it.next()).visit(visitor);
            }
            it = node.getAttributes().iterator();
            while (it.hasNext()) {
                ((ConfigurationNode)it.next()).visit(visitor);
            }
        }
        return visitor.getKeyList().iterator();
    }

    public int getMaxIndex(String key) {
        return this.fetchNodeList(key).size() - 1;
    }

    public Object clone() {
        try {
            HierarchicalConfiguration copy = (HierarchicalConfiguration)super.clone();
            CloneVisitor v = new CloneVisitor();
            this.getRootNode().visit(v);
            copy.setRootNode(v.getClone());
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }

    public Configuration interpolatedConfiguration() {
        HierarchicalConfiguration c = (HierarchicalConfiguration)this.clone();
        c.getRootNode().visit(new ConfigurationNodeVisitorAdapter(){

            public void visitAfterChildren(ConfigurationNode node) {
                node.setValue(HierarchicalConfiguration.this.interpolate(node.getValue()));
            }
        });
        return c;
    }

    protected List fetchNodeList(String key) {
        return this.getExpressionEngine().query(this.getRootNode(), key);
    }

    protected void findPropertyNodes(ConfigurationKey.KeyIterator keyPart, Node node, Collection nodes) {
    }

    protected boolean nodeDefined(Node node) {
        return this.nodeDefined((ConfigurationNode)node);
    }

    protected boolean nodeDefined(ConfigurationNode node) {
        DefinedVisitor visitor = new DefinedVisitor();
        node.visit(visitor);
        return visitor.isDefined();
    }

    protected void removeNode(Node node) {
        this.removeNode((ConfigurationNode)node);
    }

    protected void removeNode(ConfigurationNode node) {
        ConfigurationNode parent = node.getParentNode();
        if (parent != null) {
            parent.removeChild(node);
            if (!this.nodeDefined(parent)) {
                this.removeNode(parent);
            }
        }
    }

    protected void clearNode(Node node) {
        this.clearNode((ConfigurationNode)node);
    }

    protected void clearNode(ConfigurationNode node) {
        node.setValue(null);
        if (!this.nodeDefined(node)) {
            this.removeNode(node);
        }
    }

    protected Node fetchAddNode(ConfigurationKey.KeyIterator keyIt, Node startNode) {
        return null;
    }

    protected Node findLastPathNode(ConfigurationKey.KeyIterator keyIt, Node node) {
        return null;
    }

    protected Node createAddPath(ConfigurationKey.KeyIterator keyIt, Node root) {
        return null;
    }

    protected Node createNode(String name) {
        return new Node(name);
    }

    private ConfigurationNode processNodeAddData(NodeAddData data) {
        ConfigurationNode node = data.getParent();
        Iterator it = data.getPathNodes().iterator();
        while (it.hasNext()) {
            Node child = this.createNode((String)it.next());
            node.addChild(child);
            node = child;
        }
        Node child = this.createNode(data.getNewNodeName());
        if (data.isAttribute()) {
            node.addAttribute(child);
        } else {
            node.addChild(child);
        }
        return child;
    }

    protected static void clearReferences(ConfigurationNode node) {
        node.visit(new ConfigurationNodeVisitorAdapter(){

            public void visitBeforeChildren(ConfigurationNode node) {
                node.setReference(null);
            }
        });
    }

    protected static abstract class BuilderVisitor
    extends NodeVisitor {
        protected BuilderVisitor() {
        }

        public void visitBeforeChildren(Node node, ConfigurationKey key) {
            LinkedList subNodes = new LinkedList(node.getChildren());
            subNodes.addAll(node.getAttributes());
            Iterator children = subNodes.iterator();
            Node sibling1 = null;
            Node nd = null;
            while (children.hasNext()) {
                do {
                    sibling1 = nd;
                } while ((nd = (Node)children.next()).getReference() != null && children.hasNext());
                if (nd.getReference() != null) continue;
                LinkedList<Node> newNodes = new LinkedList<Node>();
                newNodes.add(nd);
                while (children.hasNext() && (nd = (Node)children.next()).getReference() == null) {
                    newNodes.add(nd);
                }
                Node sibling2 = nd.getReference() == null ? null : nd;
                Iterator it = newNodes.iterator();
                while (it.hasNext()) {
                    Node insertNode = (Node)it.next();
                    if (insertNode.getReference() != null) continue;
                    Object ref = this.insert(insertNode, node, sibling1, sibling2);
                    if (ref != null) {
                        insertNode.setReference(ref);
                    }
                    sibling1 = insertNode;
                }
            }
        }

        protected abstract Object insert(Node var1, Node var2, Node var3, Node var4);
    }

    static class CloneVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Stack copyStack = new Stack();
        private ConfigurationNode result;

        public void visitAfterChildren(ConfigurationNode node) {
            ConfigurationNode copy = (ConfigurationNode)this.copyStack.pop();
            if (this.copyStack.isEmpty()) {
                this.result = copy;
            }
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            ConfigurationNode copy = (ConfigurationNode)node.clone();
            copy.setParentNode(null);
            if (!this.copyStack.isEmpty()) {
                if (node.isAttribute()) {
                    ((ConfigurationNode)this.copyStack.peek()).addAttribute(copy);
                } else {
                    ((ConfigurationNode)this.copyStack.peek()).addChild(copy);
                }
            }
            this.copyStack.push(copy);
        }

        public ConfigurationNode getClone() {
            return this.result;
        }
    }

    class DefinedKeysVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Set keyList = new ListOrderedSet();
        private Stack parentKeys = new Stack();

        public DefinedKeysVisitor() {
        }

        public DefinedKeysVisitor(String prefix) {
            this();
            this.parentKeys.push(prefix);
        }

        public Set getKeyList() {
            return this.keyList;
        }

        public void visitAfterChildren(ConfigurationNode node) {
            this.parentKeys.pop();
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            String parentKey = this.parentKeys.isEmpty() ? null : (String)this.parentKeys.peek();
            String key = HierarchicalConfiguration.this.getExpressionEngine().nodeKey(node, parentKey);
            this.parentKeys.push(key);
            if (node.getValue() != null) {
                this.keyList.add(key);
            }
        }
    }

    static class DefinedVisitor
    extends ConfigurationNodeVisitorAdapter {
        private boolean defined;

        DefinedVisitor() {
        }

        public boolean terminate() {
            return this.isDefined();
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            this.defined = node.getValue() != null;
        }

        public boolean isDefined() {
            return this.defined;
        }
    }

    public static class NodeVisitor {
        public void visitBeforeChildren(Node node, ConfigurationKey key) {
        }

        public void visitAfterChildren(Node node, ConfigurationKey key) {
        }

        public boolean terminate() {
            return false;
        }
    }

    public static class Node
    extends DefaultConfigurationNode
    implements Serializable {
        private static final long serialVersionUID = -6357500633536941775L;

        public Node() {
        }

        public Node(String name) {
            super(name);
        }

        public Node(String name, Object value) {
            super(name, value);
        }

        public Node(ConfigurationNode src) {
            this(src.getName(), src.getValue());
            ConfigurationNode parent;
            ConfigurationNode nd;
            this.setReference(src.getReference());
            Iterator it = src.getChildren().iterator();
            while (it.hasNext()) {
                nd = (ConfigurationNode)it.next();
                parent = nd.getParentNode();
                this.addChild(nd);
                nd.setParentNode(parent);
            }
            it = src.getAttributes().iterator();
            while (it.hasNext()) {
                nd = (ConfigurationNode)it.next();
                parent = nd.getParentNode();
                this.addAttribute(nd);
                nd.setParentNode(parent);
            }
        }

        public Node getParent() {
            return (Node)this.getParentNode();
        }

        public void setParent(Node node) {
            this.setParentNode(node);
        }

        public void addChild(Node node) {
            this.addChild((ConfigurationNode)node);
        }

        public boolean hasChildren() {
            return this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
        }

        public boolean remove(Node child) {
            return child.isAttribute() ? this.removeAttribute(child) : this.removeChild(child);
        }

        public boolean remove(String name) {
            boolean childrenRemoved = this.removeChild(name);
            boolean attrsRemoved = this.removeAttribute(name);
            return childrenRemoved || attrsRemoved;
        }

        public void visit(NodeVisitor visitor, ConfigurationKey key) {
            int length = 0;
            if (key != null) {
                length = key.length();
                if (this.getName() != null) {
                    key.append(StringUtils.replace(this.isAttribute() ? ConfigurationKey.constructAttributeKey(this.getName()) : this.getName(), String.valueOf('.'), ConfigurationKey.ESCAPED_DELIMITER));
                }
            }
            visitor.visitBeforeChildren(this, key);
            Iterator it = this.getChildren().iterator();
            while (it.hasNext() && !visitor.terminate()) {
                ((Node)it.next()).visit(visitor, key);
            }
            it = this.getAttributes().iterator();
            while (it.hasNext() && !visitor.terminate()) {
                ((Node)it.next()).visit(visitor, key);
            }
            if (key != null) {
                key.setLength(length);
            }
            visitor.visitAfterChildren(this, key);
        }
    }
}

