/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.util;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oadd.org.apache.calcite.avatica.ColumnMetaData;

public class ArrayImpl
implements Array {
    private final ColumnMetaData.AvaticaType elementType;
    private final Factory factory;
    private final List list;

    public ArrayImpl(List list, ColumnMetaData.AvaticaType elementType, Factory factory) {
        this.list = list;
        this.elementType = elementType;
        this.factory = factory;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.elementType.name;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.elementType.id;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(this.list);
    }

    protected Object getArray(List list) throws SQLException {
        int i = 0;
        switch (this.elementType.rep) {
            case PRIMITIVE_DOUBLE: {
                double[] doubles = new double[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    double v = (Double)iterator.next();
                    doubles[i++] = v;
                }
                return doubles;
            }
            case PRIMITIVE_FLOAT: {
                float[] floats = new float[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    float v = ((Float)iterator.next()).floatValue();
                    floats[i++] = v;
                }
                return floats;
            }
            case PRIMITIVE_INT: {
                int[] ints = new int[list.size()];
                Iterator v = list.iterator();
                while (v.hasNext()) {
                    int v2 = (Integer)v.next();
                    ints[i++] = v2;
                }
                return ints;
            }
            case PRIMITIVE_LONG: {
                long[] longs = new long[list.size()];
                Iterator v2 = list.iterator();
                while (v2.hasNext()) {
                    long v = (Long)v2.next();
                    longs[i++] = v;
                }
                return longs;
            }
            case PRIMITIVE_SHORT: {
                short[] shorts = new short[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    short v = (Short)iterator.next();
                    shorts[i++] = v;
                }
                return shorts;
            }
            case PRIMITIVE_BOOLEAN: {
                boolean[] booleans = new boolean[list.size()];
                Iterator v = list.iterator();
                while (v.hasNext()) {
                    boolean v3 = (Boolean)v.next();
                    booleans[i++] = v3;
                }
                return booleans;
            }
            case PRIMITIVE_BYTE: {
                byte[] bytes = new byte[list.size()];
                Iterator v3 = list.iterator();
                while (v3.hasNext()) {
                    byte v = (Byte)v3.next();
                    bytes[i++] = v;
                }
                return bytes;
            }
            case PRIMITIVE_CHAR: {
                char[] chars = new char[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    char v = ((Character)iterator.next()).charValue();
                    chars[i++] = v;
                }
                return chars;
            }
        }
        Object[] objects = list.toArray();
        switch (this.elementType.id) {
            case 2003: {
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)this.elementType;
                for (i = 0; i < objects.length; ++i) {
                    objects[i] = new ArrayImpl((List)objects[i], arrayType.component, this.factory);
                }
                break;
            }
        }
        return objects;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(this.list.subList((int)index, count));
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.factory.create(this.elementType, this.list);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
    }

    public static interface Factory {
        public ResultSet create(ColumnMetaData.AvaticaType var1, Iterable<Object> var2);
    }
}

