/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.io.StringWriter;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.org.apache.calcite.avatica.remote.Handler;
import oadd.org.apache.calcite.avatica.remote.JsonService;
import oadd.org.apache.calcite.avatica.remote.Service;

public class JsonHandler
implements Handler {
    private final Service service;
    protected static final ObjectMapper MAPPER = JsonService.MAPPER;

    public JsonHandler(Service service) {
        this.service = service;
    }

    @Override
    public String apply(String jsonRequest) {
        try {
            Service.Request request = this.decode(jsonRequest, Service.Request.class);
            Service.Response response = request.accept(this.service);
            return this.encode(response);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    private <T> T decode(String request, Class<T> valueType) throws IOException {
        return MAPPER.readValue(request, valueType);
    }

    private <T> String encode(T response) throws IOException {
        StringWriter w = new StringWriter();
        MAPPER.writeValue(w, response);
        return w.toString();
    }

    protected RuntimeException handle(IOException e) {
        return new RuntimeException(e);
    }
}

