/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.BuiltInConnectionProperty;
import oadd.org.apache.calcite.avatica.ConnectionConfig;
import oadd.org.apache.calcite.avatica.ConnectionProperty;
import oadd.org.apache.calcite.avatica.DriverVersion;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.UnregisteredDriver;
import oadd.org.apache.calcite.avatica.remote.AvaticaRemoteConnectionProperty;
import oadd.org.apache.calcite.avatica.remote.MockJsonService;
import oadd.org.apache.calcite.avatica.remote.RemoteMeta;
import oadd.org.apache.calcite.avatica.remote.RemoteService;
import oadd.org.apache.calcite.avatica.remote.Service;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:avatica:remote:";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Avatica Remote JDBC Driver", "unknown version", "Avatica", "unknown version");
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, AvaticaRemoteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        Service service;
        ConnectionConfig config = connection.config();
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            URL url;
            try {
                url = new URL(config.url());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            service = new RemoteService(url);
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return new RemoteMeta(connection, service);
    }

    static {
        new Driver().register();
    }
}

