/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.typesafe.config.impl;

import oadd.com.typesafe.config.ConfigException;
import oadd.com.typesafe.config.ConfigOrigin;
import oadd.com.typesafe.config.impl.TokenType;

class Token {
    private final TokenType tokenType;
    private final String debugString;
    private final ConfigOrigin origin;

    Token(TokenType tokenType, ConfigOrigin configOrigin) {
        this(tokenType, configOrigin, null);
    }

    Token(TokenType tokenType, ConfigOrigin configOrigin, String string) {
        this.tokenType = tokenType;
        this.origin = configOrigin;
        this.debugString = string;
    }

    static Token newWithoutOrigin(TokenType tokenType, String string) {
        return new Token(tokenType, null, string);
    }

    final TokenType tokenType() {
        return this.tokenType;
    }

    final ConfigOrigin origin() {
        if (this.origin == null) {
            throw new ConfigException.BugOrBroken("tried to get origin from token that doesn't have one: " + this);
        }
        return this.origin;
    }

    final int lineNumber() {
        if (this.origin != null) {
            return this.origin.lineNumber();
        }
        return -1;
    }

    public String toString() {
        if (this.debugString != null) {
            return this.debugString;
        }
        return this.tokenType.name();
    }

    protected boolean canEqual(Object object) {
        return object instanceof Token;
    }

    public boolean equals(Object object) {
        if (object instanceof Token) {
            return this.canEqual(object) && this.tokenType == ((Token)object).tokenType;
        }
        return false;
    }

    public int hashCode() {
        return this.tokenType.hashCode();
    }
}

