/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.mongo.MongoRecordReader;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoScanBatchCreator
implements BatchCreator<MongoSubScan> {
    static final Logger logger = LoggerFactory.getLogger(MongoScanBatchCreator.class);

    public ScanBatch getBatch(FragmentContext context, MongoSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        ArrayList readers = Lists.newArrayList();
        List columns = null;
        for (MongoSubScan.MongoSubScanSpec scanSpec : subScan.getChunkScanSpecList()) {
            try {
                columns = subScan.getColumns();
                if (columns == null) {
                    columns = GroupScan.ALL_COLUMNS;
                }
                readers.add(new MongoRecordReader(scanSpec, columns, context, subScan.getMongoStoragePlugin()));
            }
            catch (Exception e) {
                logger.error("MongoRecordReader creation failed for subScan:  " + (Object)((Object)subScan) + ".");
                logger.error(e.getMessage(), (Throwable)e);
                throw new ExecutionSetupException((Throwable)e);
            }
        }
        logger.info("Number of record readers initialized : " + readers.size());
        return new ScanBatch((PhysicalOperator)subScan, context, (List)readers);
    }
}

