/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.exceptions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.management.ManagementFactory;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ErrorHelper;
import org.apache.drill.common.exceptions.UserExceptionContext;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserException
extends DrillRuntimeException {
    private static final long serialVersionUID = -6720929331624621840L;
    private static final Logger logger = LoggerFactory.getLogger(UserException.class);
    public static final String MEMORY_ERROR_MSG = "One or more nodes ran out of memory while executing the query.";
    private final UserBitShared.DrillPBError.ErrorType errorType;
    private final UserExceptionContext context;

    public static Builder memoryError(Throwable cause) {
        return UserException.resourceError(cause).message(MEMORY_ERROR_MSG, new Object[0]).addContext(cause.getMessage());
    }

    public static Builder memoryError(String format, Object ... args) {
        Builder builder = UserException.resourceError();
        builder.message(MEMORY_ERROR_MSG, new Object[0]);
        if (!format.isEmpty()) {
            builder.addContext(String.format(format, args));
        }
        return builder;
    }

    public static Builder memoryError() {
        return UserException.memoryError("", new Object[0]);
    }

    public static Builder systemError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.SYSTEM, cause);
    }

    public static Builder connectionError() {
        return UserException.connectionError(null);
    }

    public static Builder connectionError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.CONNECTION, cause);
    }

    public static Builder dataReadError() {
        return UserException.dataReadError(null);
    }

    public static Builder dataReadError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.DATA_READ, cause);
    }

    public static Builder dataWriteError() {
        return UserException.dataWriteError(null);
    }

    public static Builder dataWriteError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.DATA_WRITE, cause);
    }

    public static Builder functionError() {
        return UserException.functionError(null);
    }

    public static Builder functionError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.FUNCTION, cause);
    }

    public static Builder parseError() {
        return UserException.parseError(null);
    }

    public static Builder parseError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.PARSE, cause);
    }

    public static Builder validationError() {
        return UserException.validationError(null);
    }

    public static Builder validationError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.VALIDATION, cause);
    }

    public static Builder permissionError() {
        return UserException.permissionError(null);
    }

    public static Builder permissionError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.PERMISSION, cause);
    }

    public static Builder planError() {
        return UserException.planError(null);
    }

    public static Builder planError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.PLAN, cause);
    }

    public static Builder resourceError() {
        return UserException.resourceError(null);
    }

    public static Builder resourceError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.RESOURCE, cause);
    }

    public static Builder unsupportedError() {
        return UserException.unsupportedError(null);
    }

    public static Builder unsupportedError(Throwable cause) {
        return new Builder(UserBitShared.DrillPBError.ErrorType.UNSUPPORTED_OPERATION, cause);
    }

    protected UserException(UserBitShared.DrillPBError.ErrorType errorType, String message, Throwable cause) {
        super(message, cause);
        this.errorType = errorType;
        this.context = new UserExceptionContext();
    }

    private UserException(Builder builder) {
        super(builder.message, builder.cause);
        this.errorType = builder.errorType;
        this.context = builder.context;
    }

    @Override
    public String getMessage() {
        return this.generateMessage(true);
    }

    public String getMessage(boolean includeErrorIdAndIdentity) {
        return this.generateMessage(includeErrorIdAndIdentity);
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    public String getVerboseMessage() {
        return this.getVerboseMessage(true);
    }

    public String getVerboseMessage(boolean includeErrorIdAndIdentity) {
        return this.generateMessage(includeErrorIdAndIdentity) + "\n\n" + ErrorHelper.buildCausesMessage(this.getCause());
    }

    public UserBitShared.DrillPBError getOrCreatePBError(boolean verbose) {
        String message = verbose ? this.getVerboseMessage() : this.getMessage();
        UserBitShared.DrillPBError.Builder builder = UserBitShared.DrillPBError.newBuilder();
        builder.setErrorType(this.errorType);
        builder.setErrorId(this.context.getErrorId());
        if (this.context.getEndpoint() != null) {
            builder.setEndpoint(this.context.getEndpoint());
        }
        builder.setMessage(message);
        if (this.getCause() != null) {
            builder.setException(ErrorHelper.getWrapper(this.getCause()));
        }
        return builder.build();
    }

    public String getErrorId() {
        return this.context.getErrorId();
    }

    public UserBitShared.DrillPBError.ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorLocation() {
        CoordinationProtos.DrillbitEndpoint ep = this.context.getEndpoint();
        if (ep != null) {
            return ep.getAddress() + ":" + ep.getUserPort();
        }
        return null;
    }

    private String generateMessage(boolean includeErrorIdAndIdentity) {
        return this.errorType + " ERROR: " + super.getMessage() + "\n\n" + this.context.generateContextMessage(includeErrorIdAndIdentity);
    }

    public static class Builder {
        private final Throwable cause;
        private final UserBitShared.DrillPBError.ErrorType errorType;
        private final UserException uex;
        private final UserExceptionContext context;
        private String message;

        private Builder(UserBitShared.DrillPBError.ErrorType errorType, Throwable cause) {
            this.cause = cause;
            this.uex = ErrorHelper.findWrappedUserException(cause);
            if (this.uex != null) {
                this.errorType = null;
                this.context = this.uex.context;
            } else {
                this.errorType = errorType;
                this.context = new UserExceptionContext();
                this.message = cause != null ? cause.getMessage() : null;
            }
        }

        public Builder message(String format, Object ... args) {
            if (this.uex == null && format != null) {
                this.message = String.format(format, args);
            }
            return this;
        }

        public Builder addIdentity(CoordinationProtos.DrillbitEndpoint endpoint) {
            this.context.add(endpoint);
            return this;
        }

        public Builder addContext(String value) {
            this.context.add(value);
            return this;
        }

        public Builder addContext(String value, Object ... args) {
            this.context.add(String.format(value, args));
            return this;
        }

        public Builder addContext(String name, String value) {
            this.context.add(name, value);
            return this;
        }

        public Builder addContext(String name, long value) {
            this.context.add(name, value);
            return this;
        }

        public Builder addContext(String name, double value) {
            this.context.add(name, value);
            return this;
        }

        public Builder pushContext(String value) {
            this.context.push(value);
            return this;
        }

        public Builder pushContext(String name, String value) {
            this.context.push(name, value);
            return this;
        }

        public Builder pushContext(String name, long value) {
            this.context.push(name, value);
            return this;
        }

        public Builder pushContext(String name, double value) {
            this.context.push(name, value);
            return this;
        }

        public UserException build(Logger logger) {
            boolean isSystemError;
            File spinFile = new File("/tmp/drill/spin");
            if (spinFile.exists()) {
                File tmpDir = new File("/tmp/drill");
                File outErr = null;
                try {
                    outErr = File.createTempFile("spin", ".tmp", tmpDir);
                    BufferedWriter bw = new BufferedWriter(new FileWriter(outErr));
                    bw.write("Spinning process: " + ManagementFactory.getRuntimeMXBean().getName());
                    bw.write("\nError cause: " + (this.errorType == UserBitShared.DrillPBError.ErrorType.SYSTEM ? "SYSTEM ERROR: " + ErrorHelper.getRootMessage(this.cause) : this.message));
                    bw.close();
                }
                catch (Exception ex) {
                    logger.warn("Failed creating a spinner tmp message file: {}", (Throwable)ex);
                }
                while (spinFile.exists()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {}
                }
                try {
                    outErr.delete();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.uex != null) {
                return this.uex;
            }
            boolean bl = isSystemError = this.errorType == UserBitShared.DrillPBError.ErrorType.SYSTEM;
            if (isSystemError) {
                this.message = ErrorHelper.getRootMessage(this.cause);
            }
            UserException newException = new UserException(this);
            if (isSystemError) {
                logger.error(newException.getMessage(), (Throwable)newException);
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("User Error Occurred");
                if (this.message != null) {
                    buf.append(": ").append(this.message);
                }
                if (this.cause != null) {
                    buf.append(" (").append(this.cause.getMessage()).append(")");
                }
                logger.info(buf.toString(), (Throwable)newException);
            }
            return newException;
        }

        @Deprecated
        public UserException build() {
            return this.build(logger);
        }
    }
}

